/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-endpoint-using-unchecked-url", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidEndpointUsingUncheckedUrlCheck
extends CheckImplementationBase {
    private static final String FINDINGS_MESSAGE = "Endpoint using an unchecked URL can be insecure: ";
    private static final Set<String> REST_ENDPOINTS = Set.of("HttpGet", "HttpPost", "HttpPut", "HttpDelete", "HttpPatch", "HttpHead", "HttpOptions");
    private static final Set<String> REST_ENDPOINTS_FULLY_QUALIFIED = Set.of("Microsoft.AspNetCore.Mvc.HttpGet", "Microsoft.AspNetCore.Mvc.HttpPost", "Microsoft.AspNetCore.Mvc.HttpPut", "Microsoft.AspNetCore.Mvc.HttpDelete", "Microsoft.AspNetCore.Mvc.HttpPatch", "Microsoft.AspNetCore.Mvc.HttpHead", "Microsoft.AspNetCore.Mvc.HttpOptions");
    private static final Set<String> REST_ENDPOINTS_FULLY_QUALIFIED_OLD = Set.of("System.Web.Mvc.HttpGet", "System.Web.Mvc.HttpPost", "System.Web.Mvc.HttpPut", "System.Web.Mvc.HttpDelete", "System.Web.Mvc.HttpPatch", "System.Web.Mvc.HttpHead", "System.Web.Mvc.HttpOptions");

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), Set.of(EShallowEntityType.METHOD));
        Set<String> namesOfRestEndpoints = this.getNamesOfRestEndpoints();
        for (ShallowEntity method : methods) {
            if (!AvoidEndpointUsingUncheckedUrlCheck.isUrlArgument(method, namesOfRestEndpoints)) continue;
            this.processMethod(method);
        }
    }

    private Set<String> getNamesOfRestEndpoints() throws CheckException {
        HashSet<String> namesOfRestEndpoints = new HashSet<String>();
        namesOfRestEndpoints.addAll(REST_ENDPOINTS_FULLY_QUALIFIED);
        namesOfRestEndpoints.addAll(REST_ENDPOINTS_FULLY_QUALIFIED_OLD);
        List metaChildren = this.context.getRootEntity(this.getCodeViewOption()).getChildrenOfType(EShallowEntityType.META);
        for (ShallowEntity meta : metaChildren) {
            if (!"Microsoft.AspNetCore.Mvc".equals(meta.getName()) && !"System.Web.Mvc".equals(meta.getName())) continue;
            namesOfRestEndpoints.addAll(REST_ENDPOINTS);
            break;
        }
        return namesOfRestEndpoints;
    }

    private static boolean isUrlArgument(ShallowEntity method, Set<String> namesOfRestEndpoints) {
        return CLikeLanguageFeatureParserBase.hasAnnotation((ShallowEntity)method, namesOfRestEndpoints);
    }

    private static List<String> getUrlArguments(ShallowEntity method) {
        ArrayList<String> urlVariables = new ArrayList<String>();
        List parameterListTokens = TokenStreamUtils.tokensBetweenWithNesting((List)method.ownStartTokens(), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        for (int i = 0; i < parameterListTokens.size() - 1; ++i) {
            IToken parameterToken = (IToken)parameterListTokens.get(i + 1);
            if (!AvoidEndpointUsingUncheckedUrlCheck.isUrlArgument((IToken)parameterListTokens.get(i), parameterToken)) continue;
            urlVariables.add(parameterToken.getText());
        }
        return urlVariables;
    }

    private static boolean isUrlArgument(IToken previousParameterToken, IToken parameterToken) {
        return parameterToken.getType() == ETokenType.IDENTIFIER && (previousParameterToken.getType() == ETokenType.STRING || previousParameterToken.getType() == ETokenType.IDENTIFIER && "Uri".equals(previousParameterToken.getText()));
    }

    private void processMethod(ShallowEntity method) throws CheckException {
        List<String> urlVariables = AvoidEndpointUsingUncheckedUrlCheck.getUrlArguments(method);
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)method.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (int i = 0; i < urlVariables.size(); ++i) {
            ShallowEntity statement;
            boolean firstUrlUsageFound;
            Iterator iterator = statements.iterator();
            while (iterator.hasNext() && !(firstUrlUsageFound = this.processStatement(statement = (ShallowEntity)iterator.next(), urlVariables.get(i), urlVariables))) {
            }
        }
    }

    private boolean processStatement(ShallowEntity statement, String urlVariable, List<String> urlVariables) throws CheckException {
        UnmodifiableList tokens = statement.ownStartTokens();
        int indexUrlAsArgument = AvoidEndpointUsingUncheckedUrlCheck.firstIndexOfVariableIfMethodArgument((List<IToken>)tokens, urlVariable);
        if (indexUrlAsArgument != -1) {
            int methodIndex = indexUrlAsArgument - 2;
            Optional<String> createdUri = AvoidEndpointUsingUncheckedUrlCheck.getNameIfStatementCreatesUri((List<IToken>)tokens);
            if (createdUri.isPresent()) {
                urlVariables.add(createdUri.get());
            } else if (this.isCriticalMethodCall(statement, (List<IToken>)tokens, methodIndex)) {
                this.buildFinding(FINDINGS_MESSAGE + urlVariable, this.buildLocation().forToken((IToken)tokens.get(indexUrlAsArgument))).createAndStore();
            }
            return true;
        }
        return false;
    }

    private static int firstIndexOfVariableIfMethodArgument(List<IToken> statementTokens, String variable) {
        int index = TokenStreamTextUtils.findFirst(statementTokens, (String)variable);
        if (index >= 2 && statementTokens.get(index - 1).getType() == ETokenType.LPAREN && statementTokens.get(index - 2).getType() == ETokenType.IDENTIFIER) {
            return index;
        }
        return -1;
    }

    private static Optional<String> getNameIfStatementCreatesUri(List<IToken> statementTokens) {
        if (statementTokens.size() < 8) {
            return Optional.empty();
        }
        String constructorName = statementTokens.get(4).getText();
        if (TokenStreamUtils.startsWith(statementTokens, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.NEW}) && "Uri".equals(constructorName)) {
            return Optional.of(statementTokens.get(1).getText());
        }
        return Optional.empty();
    }

    private boolean isCriticalMethodCall(ShallowEntity statement, List<IToken> statementTokens, int methodIndex) throws CheckException {
        if (methodIndex >= 2 && statementTokens.get(methodIndex - 2).getType() == ETokenType.IDENTIFIER && statementTokens.get(methodIndex - 1).getType() == ETokenType.DOT) {
            String objectName = statementTokens.get(methodIndex - 2).getText();
            String methodName = statementTokens.get(methodIndex).getText();
            return this.isObjectOfTypeHttpClient(statement, objectName) && methodName != null && methodName.endsWith("Async");
        }
        return false;
    }

    private boolean isObjectOfTypeHttpClient(ShallowEntity statement, String objectName) throws CheckException {
        ScopedTypeLookup lookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(statement);
        if (lookup.containsVariable(objectName)) {
            TypedVariable typeInfo = lookup.getTypeInfo(objectName);
            return typeInfo != null && "HttpClient".equals(typeInfo.getTypeNameWithoutGenericTypeParameter());
        }
        return false;
    }
}

