/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.clike.CLikeAvoidUnusedPrivateFieldsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.List;

@Check(id="cqse-cs-avoid-unused-private-fields", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class CsAvoidUnusedPrivateFieldsCheck
extends CLikeAvoidUnusedPrivateFieldsCheckBase {
    public CsAvoidUnusedPrivateFieldsCheck() {
        super((CLikeLanguageFeatureParserBase)LanguageFeatureParser.CS);
    }

    @Override
    protected String getFieldSelectionXPath() {
        return "//TYPE[not(tokens('partial'))]/ATTRIBUTE[subtype('attribute') and not(anymodifier('public','protected','internal'))]";
    }

    @Override
    protected String getProcessedEntitiesXPath() {
        return "descendant::ATTRIBUTE | descendant::STATEMENT | descendant::META[subtype('case')] | descendant::META[subtype('attribute annotation')] | descendant::METHOD";
    }

    @Override
    protected boolean analyzeTokens(List<IToken> tokens, String fieldName, EShallowEntityType entityType, boolean isShadowed) {
        if (entityType == EShallowEntityType.METHOD) {
            tokens = new ArrayList<IToken>(tokens);
            tokens.addAll(this.languageFeatureParser.getParameterAnnotations(tokens, false));
        }
        return !this.languageFeatureParser.getVariableReadsFromTokens(tokens, fieldName, true, isShadowed).isEmpty();
    }
}

