/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.java.ImportCheckBase;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-no-star-imports", languages={ELanguage.JAVA, ELanguage.XTEND}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoStarImportsCheck
extends ImportCheckBase {
    @Override
    protected void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList statementTokens = entity.includedTokens();
        int numTokens = statementTokens.size();
        CCSMAssert.isTrue((numTokens > 1 ? 1 : 0) != 0, (String)"There should be at least 2 included tokens per entity.");
        if (((IToken)statementTokens.get(1)).getType() == ETokenType.STATIC) {
            return;
        }
        if (((IToken)statementTokens.get(numTokens - 1)).getType() == ETokenType.MULT || ((IToken)statementTokens.get(numTokens - 2)).getType() == ETokenType.MULT) {
            this.buildFinding("Star import of " + MarkupUtils.formatAsSourceCode((String)entity.getName()) + " should not be used", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

