/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-public-class-thread-safety", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PublicClassThreadSafetyCheck
extends CheckImplementationBase {
    private static final Set<String> CONCERNED_INSTANCES = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"DateFormat", "SimpleDateFormat", "Calendar", "GregorianCalendar", "SchemaFactory", "XPath"});

    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            if (!TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.STATIC)) continue;
            this.processEntity(attribute);
        }
    }

    private void processEntity(ShallowEntity entity) {
        int indexOfConcernedInstance = TokenStreamTextUtils.findFirst((List)entity.includedTokens(), CONCERNED_INSTANCES);
        if (indexOfConcernedInstance == -1) {
            return;
        }
        boolean isGenericOrAssignmentValue = TokenStreamUtils.containsAny((List)entity.includedTokens(), (int)0, (int)indexOfConcernedInstance, (ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.LT});
        if (!isGenericOrAssignmentValue) {
            this.buildFinding("Field `" + entity.getName() + "` should not be static", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

