/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-unit-test-package-match", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnitTestPackageMatchCheck
extends CheckImplementationBase {
    private static final String X_PATH_PACKAGE = "/META[subtype('package')]";
    private static final String X_PATH_IMPORTS = "/META[subtype('import')]";
    private static final String X_PATH_TEST_CLASSES_PATTERN = "/TYPE[subtype('class') and name-matches('%s')]";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String CLASS_NAME_GROUP = "className";
    @CheckOption(name="Test class name ending", description="The class name suffix of test classes in form of a regular expression (e.g. \"Test\" or \"Test|IT\")")
    private String testClassNameSuffixPattern = "Test";
    private Pattern testClassNamePattern;

    public void initialize() throws CheckException {
        try {
            this.testClassNamePattern = Pattern.compile(String.format("^(?<%s>.*)(%s)$", CLASS_NAME_GROUP, this.testClassNameSuffixPattern));
        }
        catch (PatternSyntaxException e) {
            throw new CheckException("Could not translate \"" + this.testClassNameSuffixPattern + "\" into a valid regular expression", (Exception)e);
        }
    }

    public void execute() throws CheckException {
        String xPathTestClasses = String.format(X_PATH_TEST_CLASSES_PATTERN, this.testClassNamePattern.pattern());
        List testClasses = this.select(xPathTestClasses);
        for (ShallowEntity testClassUnit : testClasses) {
            this.checkTestClass(testClassUnit);
        }
    }

    private void checkTestClass(ShallowEntity testClassEntity) throws CheckException {
        String expectedNameOfClassUnderTest = this.getNameOfExpectedClassUnderTest(testClassEntity.getName());
        ShallowEntity packageEntity = this.getPackageEntity();
        String testClassPackagePrefix = UnitTestPackageMatchCheck.getPackagePrefixFromPackageEntity(packageEntity);
        List importStatements = this.select(X_PATH_IMPORTS);
        for (ShallowEntity importStatement : importStatements) {
            if (!UnitTestPackageMatchCheck.isTestClassInWrongPackage(testClassPackagePrefix, expectedNameOfClassUnderTest, importStatement)) continue;
            this.createFinding(testClassEntity, UnitTestPackageMatchCheck.getPackageNameFromImportStatement(importStatement));
            break;
        }
    }

    private static String getPackagePrefixFromPackageEntity(ShallowEntity packageEntity) {
        if (packageEntity != null) {
            return packageEntity.getName() + ".";
        }
        return "";
    }

    private static String getPackageNameFromImportStatement(ShallowEntity importStatement) {
        if (importStatement != null) {
            return StringUtils.removeLastPart((String)importStatement.getName(), (char)'.');
        }
        return "";
    }

    private void createFinding(ShallowEntity testClassEntity, String expectedPackageName) {
        String message = MarkupUtils.formatAsSourceCode((String)testClassEntity.getName()) + " should be in package " + MarkupUtils.formatAsSourceCode((String)expectedPackageName);
        this.buildFinding(message, this.buildLocation().forEntityFirstLine(testClassEntity, ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
    }

    private ShallowEntity getPackageEntity() throws CheckException {
        List packageDeclarations = this.select(X_PATH_PACKAGE);
        if (!packageDeclarations.isEmpty()) {
            return (ShallowEntity)packageDeclarations.get(0);
        }
        return null;
    }

    private static boolean isTestClassInWrongPackage(String testClassPackagePrefix, String expectedSimpleNameOfClassUnderTest, ShallowEntity importStatement) {
        String qualifiedImportClassName = importStatement.getName();
        if (expectedSimpleNameOfClassUnderTest.equals(StringUtils.getLastPart((String)qualifiedImportClassName, (char)'.'))) {
            return !qualifiedImportClassName.equals(testClassPackagePrefix + expectedSimpleNameOfClassUnderTest);
        }
        return false;
    }

    private String getNameOfExpectedClassUnderTest(String testClassName) {
        Matcher testClassNameMatcher = this.testClassNamePattern.matcher(testClassName);
        CCSMAssert.isTrue((boolean)testClassNameMatcher.matches(), (String)"Unexpected test class name");
        String className = testClassNameMatcher.group(CLASS_NAME_GROUP);
        CCSMAssert.isNotNull((Object)className, () -> String.format("Could not extract class name out of test class name \"%s\" and pattern \"%s\"", testClassName, this.testClassNameSuffixPattern));
        return className;
    }
}

