/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.python.PythonImportExtractor;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.markup.MarkupUtils;

public abstract class PythonImportCheckBase
extends CheckImplementationBase {
    public void execute() throws CheckException {
        ListMap<String, ShallowEntity> imports = PythonImportExtractor.extractImports(this.context.getRootEntity(ECodeViewOption.FILTERED));
        for (String incompatiblePackage : this.getIncompatibleModules()) {
            List violatingEntities = (List)imports.getCollectionOrEmpty((Object)incompatiblePackage);
            for (ShallowEntity violatingEntity : violatingEntities) {
                this.buildFinding(this.getFindingsMessagePrefix() + " incompatible standard libraries " + MarkupUtils.formatAsSourceCode((String)incompatiblePackage), this.buildLocation().forEntity(violatingEntity)).createAndStore();
            }
        }
    }

    protected abstract String getFindingsMessagePrefix();

    protected abstract Set<String> getIncompatibleModules();
}

