/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLineLayoutUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.na_0008", languages={ELanguage.SIMULINK})
public class SimulinkSignalLabelCheck
extends CheckImplementationBase {
    @CheckOption(name="Block types that require outgoing signals to have a label", description="These block types require that all outgoing signals have a label. Outgoing signals are allowed without label if the signal name is visible in the origin block or is derived from a constant value with a meaningful name. See check description for details. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).")
    private Set<String> srcBlockTypes = CollectionUtils.asHashSet((Object[])new String[]{"Inport", "InportShadow", "From", "Demux", "Selector", "DataStoreRead", "SubSystem", "Constant"});
    @CheckOption(name="Block types that require incoming signals to have a label", description="These block types require that all incoming signals have a label. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).")
    private Set<String> dstBlockTypes = CollectionUtils.asHashSet((Object[])new String[]{"Outport", "Goto", "DataStoreWrite", "BusCreator", "Mux", "SubSystem"});
    private static final Set<String> SRC_BLOCK_TYPES_THAT_REQUIRE_SIGNAL_LABELS_EVEN_IF_ICON_DISPLAY_IS_SET = CollectionUtils.asHashSet((Object[])new String[]{"Inport", "InportShadow", "BusSelector", "Demux", "Selector"});
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Add a new or propagated label to the signal line.");
    private static final Comparator<Point> POINT_COMPARATOR = Comparator.comparing(Point::getX).thenComparing(Point::getY);
    private static final Comparator<SimulinkLine> LINE_COMPARATOR = Comparator.comparing(line -> line.getDstPort().obtainLayoutData().getPosition(), POINT_COMPARATOR);

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            Set sourcePorts = CollectionUtils.mapToSet(SimulinkSignalLabelCheck.retainConnectedAndVisibleLines((UnmodifiableCollection<SimulinkLine>)block.getContainedLines()), SimulinkLine::getSrcPort);
            for (SimulinkOutPort sourcePort : sourcePorts) {
                this.checkLinesFromSourcePort(sourcePort);
            }
        }
    }

    private void checkLinesFromSourcePort(SimulinkOutPort srcPort) {
        UnmodifiableSet linesFromSourcePort = srcPort.getLines();
        if (linesFromSourcePort.stream().anyMatch(line -> SimulinkLineLayoutUtils.determineLineLabelText((SimulinkLine)line) != null)) {
            return;
        }
        SimulinkBlock srcBlock = srcPort.getBlock();
        boolean srcBlockRequiresSignalLabel = this.srcBlockRequiresSignalLabel(srcBlock, srcPort);
        if (srcBlockRequiresSignalLabel) {
            String markupSrcBlockName = MarkupUtils.formatAsSourceCode((String)srcBlock.getNamePretty());
            SimulinkLine representativeLine = SimulinkSignalLabelCheck.selectRepresentativeLine((UnmodifiableSet<SimulinkLine>)srcPort.getLines());
            this.buildFinding("Unlabeled signal must be labeled (required by source block " + markupSrcBlockName + ")", (ElementLocation)this.buildLocation().forSimulinkLine(representativeLine)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
        for (SimulinkLine line2 : srcPort.getLines()) {
            SimulinkBlock dstBlock;
            String dstBlockType;
            boolean dstBlockRequiresSignalLabel;
            if (line2.hasUnconnectedEndpoint() || line2.getDstPort().isSpecialPort() || !(dstBlockRequiresSignalLabel = this.dstBlockTypes.contains(dstBlockType = (dstBlock = line2.getDstPort().getBlock()).getType()) && !SimulinkSignalLabelCheck.signalLabelIsShownInDstBlock(line2))) continue;
            String markupDstBlockName = MarkupUtils.formatAsSourceCode((String)dstBlock.getNamePretty());
            this.buildFinding("Unlabeled signal must be labeled (required by destination block " + markupDstBlockName + ")", (ElementLocation)this.buildLocation().forSimulinkLine(line2)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private boolean srcBlockRequiresSignalLabel(SimulinkBlock srcBlock, SimulinkOutPort sourcePort) {
        if (srcBlock.isOfType("Constant") && this.srcBlockTypes.contains("Constant")) {
            return !SimulinkSignalLabelCheck.hasNamedConstantValue(srcBlock) && !SimulinkSignalLabelCheck.signalLabelIsShownInSourceBlock(sourcePort);
        }
        return this.srcBlockTypes.contains(srcBlock.getType()) && !SimulinkSignalLabelCheck.signalLabelIsShownInSourceBlock(sourcePort);
    }

    private static SimulinkLine selectRepresentativeLine(UnmodifiableSet<SimulinkLine> lines) {
        return lines.stream().min(LINE_COMPARATOR).get();
    }

    private static List<SimulinkLine> retainConnectedAndVisibleLines(UnmodifiableCollection<SimulinkLine> containedLines) {
        ArrayList<SimulinkLine> resultLines = new ArrayList<SimulinkLine>();
        for (SimulinkLine line : containedLines) {
            if (!SimulinkUtils.isUserVisible((SimulinkLine)line) || line.hasUnconnectedEndpoint()) continue;
            resultLines.add(line);
        }
        return resultLines;
    }

    private static boolean signalLabelIsShownInDstBlock(SimulinkLine line) {
        SimulinkBlock dstBlock = line.getDstPort().getBlock();
        return dstBlock.isOfType("SubSystem") && SimulinkSignalLabelCheck.signalLabelsAreShownInBlock(dstBlock);
    }

    private static boolean signalLabelIsShownInSourceBlock(SimulinkOutPort sourcePort) {
        SimulinkBlock srcBlock = sourcePort.getBlock();
        if (srcBlock.isOfType("SubSystem")) {
            return SimulinkSignalLabelCheck.signalLabelsAreShownInBlock(srcBlock);
        }
        if (SRC_BLOCK_TYPES_THAT_REQUIRE_SIGNAL_LABELS_EVEN_IF_ICON_DISPLAY_IS_SET.contains(srcBlock.getType())) {
            return false;
        }
        String iconDisplayParameter = srcBlock.getParameter("IconDisplay");
        return "Signal name".equals(iconDisplayParameter) || "Tag and signal name".equals(iconDisplayParameter);
    }

    private static boolean signalLabelsAreShownInBlock(SimulinkBlock block) {
        return "SignalName".equals(block.getParameter("ShowPortLabels"));
    }

    private static boolean hasNamedConstantValue(SimulinkBlock block) {
        String value = block.getParameter("Value");
        if (value == null) {
            return false;
        }
        String firstCharacter = value.substring(0, 1);
        return StringUtils.isAlpha((CharSequence)firstCharacter);
    }
}

