/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.jc_0762", languages={ELanguage.SIMULINK})
public class SimulinkProhibitionOfStateActionAndFlowChartCheck
extends CheckImplementationBase {
    private static final String STATE_ACTION_AND_FLOW_CHART_FINDING_MESSAGE = "The state %s has both an action as well as a flow chart";
    private static final FindingPropertyList STATE_ACTION_AND_FLOW_CHART_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider either removing the action or the flow chart.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateflowBlock = (StateflowBlock)block;
            for (IStateflowNodeContainer state : StateflowUtils.listFlowCharts((StateflowChart)stateflowBlock.getChart(), (boolean)false)) {
                StateflowState stateflowState;
                List actions;
                if (!(state instanceof StateflowState) || SimulinkProhibitionOfStateActionAndFlowChartCheck.containsNoStateActionOrOnlyComments(actions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)(stateflowState = (StateflowState)state)))) continue;
                this.buildFinding(String.format(STATE_ACTION_AND_FLOW_CHART_FINDING_MESSAGE, StateflowUtils.getStateName((StateflowState)stateflowState)), (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)stateflowState)).addFindingProperties(STATE_ACTION_AND_FLOW_CHART_RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private static boolean containsNoStateActionOrOnlyComments(List<StateflowStateAction> actions) {
        if (actions.isEmpty()) {
            return true;
        }
        if (actions.size() > 1) {
            return false;
        }
        StateflowStateAction stateAction = actions.get(0);
        return stateAction.actionDeclaration.isEmpty() && stateAction.actionCode.stream().allMatch(token -> token.getType() == ETokenType.EOL || ETokenType.COMMENTS.contains((Object)token.getType()));
    }
}

