/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedSetRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.SimpleNLPUtils;

@Check(id="cqse-wia-avoid-passive-voice", languages={ELanguage.NL_REQUIREMENTS, ELanguage.NL_TESTS})
public class AvoidPassiveVoiceCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "Avoid Passive Voice";
    @CheckOption(name="Avoid Passive Voice Dictionary", description="Comma separated list of past tense irregular verbs.")
    private Set<String> irregularVerbs = Set.of("awoken", "beat", "become", "begun", "bent", "beset", "bet", "bid", "bidden", "bitten", "bled", "blown", "born", "bought", "bound", "bred", "broadcast", "broken", "brought", "built", "burnt", "burst", "cast", "caught", "chosen", "clung", "come", "cost", "crept", "cut", "dealt", "dived", "done", "drawn", "dreamt", "driven", "drunk", "dug", "eaten", "fallen", "fed", "felt", "fit", "fled", "flown", "flung", "forbidden", "foregone", "forgiven", "forgotten", "forsaken", "fought", "found", "frozen", "given", "gone", "gotten", "ground", "grown", "heard", "held", "hidden", "hit", "hung", "hurt", "kept", "knelt", "knit", "known", "laid", "lain", "leapt", "learnt", "led", "left", "lent", "let", "lighted", "lost", "made", "meant", "met", "misspelt", "mistaken", "mown", "overcome", "overdone", "overtaken", "overthrown", "paid", "pled", "proven", "put", "quit", "read", "rid", "ridden", "risen", "run", "rung", "said", "sat", "sawn", "seen", "sent", "set", "sewn", "shaken", "shaven", "shed", "shod", "shone", "shorn", "shot", "shown", "shrunk", "shut", "slain", "slept", "slid", "slit", "slung", "smitten", "sold", "sought", "sown", "sped", "spent", "spilt", "spit", "split", "spoken", "spread", "sprung", "spun", "stolen", "stood", "stridden", "striven", "struck", "strung", "stuck", "stung", "stunk", "sung", "sunk", "swept", "swollen", "sworn", "swum", "swung", "taken", "taught", "thought", "thrived", "thrown", "thrust", "told", "torn", "trodden", "understood", "upheld", "upset", "wed", "wept", "withheld", "withstood", "woken", "won", "worn", "wound", "woven", "written", "wrung");
    @CheckOption(name="Avoid Passive Voice - Text ignore patterns (regex)", description="A list of comma separated Java regex patterns for text parts that are ignored and\nnot included in the detection of this check.\nFor example, the regex `\".*?\"` ignores text that is enclosed in double quotes.\n")
    private List<String> ignorePatterns = List.of("\".*?\"", "(?<=\\W|^)'.*?'");
    @CheckOption(name="Avoid Passive Voice - Rules", description="The list of rules that specify for which *item types* and which *item fields* this check is executed.\nMultiple rules are separated by comma or new-lines.\n<p>\nA rule has the format:\n\n`<itemTypes> -> <fieldNames>`\n\n`<itemTypes>`: a `|` separated list of item types.<br>\nThis check is executed for all listed types.\nA type must be specified as full name (e.g., `Requirement`)\tor its abbreviation (e.g., `REQ`).\nThe special placeholder `ANY` can be used in place of a concrete type list to execute this check irrespective of the item types.\n\n`<fieldNames>`: a `|` separated list of item fields.<br>\nThis check is executed on all listed fields that are present in any of the item types of the same rule.\nThe special placeholder `ALL` can be used in place of a concrete field list to execute this check on all fields.\n\nHere are some example rules:\n+ `Requirement -> Description`<br>\n  The check is executed on the `Description` field of `Requirement` items.\n+ `REQ | WI -> Description | Status`<br>\n  The check is executed on the `Description` and `Status` fields of `REQ` and `WI` items.\n+ `ANY -> Description`<br>\n  The check is executed on the `Description` field of all items irrespective of their types.\n+ `REQ -> ALL`<br>\n  The check is executed on all fields of `REQ` items.\n+ `ANY -> ALL`<br>\n  The check is executed on all fields all items irrespective of their types.\n", multilineText=true)
    private Set<String> rawAvoidPassiveVoiceRules = Collections.emptySet();
    private final Set<TypedSetRule<String>> parsedAvoidPassiveVoiceRules = new HashSet<TypedSetRule<String>>();
    private static final TypedSetRule.Parser<String> PARSER = new TypedSetRule.Parser<String>().withValueParser(ParsableRule.RuleParser.TO_STRING);
    private Pattern compiledIgnorePattern;
    private Pattern compiledPassiveVoicePattern;

    public AvoidPassiveVoiceCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        StringJoiner combinedIgnorePattern = new StringJoiner(")|(", "(", ")");
        this.ignorePatterns.forEach(combinedIgnorePattern::add);
        this.compiledIgnorePattern = Pattern.compile(combinedIgnorePattern.toString());
        this.createPassiveVoicePattern();
        for (String rawRule : this.rawAvoidPassiveVoiceRules) {
            this.parsedAvoidPassiveVoiceRules.add((TypedSetRule<String>)PARSER.parse(rawRule));
        }
    }

    private void createPassiveVoicePattern() {
        StringJoiner combinedIrregularPattern = new StringJoiner("|");
        this.irregularVerbs.forEach(combinedIrregularPattern::add);
        String passiveVoicePattern = "\\b(be|is|was|were|been|being|will\\s+be|got)\\s+(?:\\w+ed|" + String.valueOf(combinedIrregularPattern) + ")\\b";
        this.compiledPassiveVoicePattern = Pattern.compile(passiveVoicePattern, 34);
    }

    @Override
    protected void execute(SpecItem workItem) throws CheckException {
        for (TypedSetRule<String> rule : this.parsedAvoidPassiveVoiceRules) {
            if (!rule.matches(workItem)) continue;
            if (rule.values.contains("ALL")) {
                for (String field : this.getDescriber((TeamscaleIssue)workItem).getNonTechnicalKeys((TeamscaleIssue)workItem)) {
                    this.checkViolation(workItem, field);
                }
                continue;
            }
            for (String field : rule.values) {
                this.checkViolation(workItem, field);
            }
        }
    }

    private void checkViolation(SpecItem item, String field) {
        WorkItemDescriberBase.IValueDescriber valueDescriber = this.getDescriber((TeamscaleIssue)item).getValueDescriber(field);
        String fieldValue = valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED);
        if (fieldValue == null) {
            return;
        }
        String censoredValue = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)this.compiledIgnorePattern, (String)fieldValue.toLowerCase());
        Matcher matcher = this.compiledPassiveVoicePattern.matcher(censoredValue);
        while (matcher.find()) {
            this.buildFinding(AvoidPassiveVoiceCheck.buildFindingMessage(matcher.group()), this.buildLocation().forAttribute(valueDescriber.getExactKeyName((TeamscaleIssue)item), valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.RAW))).addFindingProperties(AvoidPassiveVoiceCheck.buildProperties(item, field, matcher.group())).createAndStore();
        }
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem specItem, String violatedField, String expression) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)specItem.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        properties.addProperty("Expression", (Object)expression);
        return properties;
    }

    public static String buildFindingMessage(String expression) {
        return "Prefer active over passive voice: '%s'".formatted(MarkupUtils.escapeMarkdownRelevantSymbols((String)expression));
    }
}

