/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeFalse;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeTrue;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformationFactory;

public class CLikeConditionEvaluator
extends ConditionEvaluatorBase {
    private static final String ZERO_REPRESENTATION = "-?(0|0.0(f|d|l|F|D|L|df|dd|dl|DF|DD|DL)?|0e0)";
    private final ELanguage language;
    private static final List<Set<ETokenType>> CLIKE_OPERATORS = List.of(Set.of(ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ), Set.of(), Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.OR), Set.of(ETokenType.XOR), Set.of(ETokenType.AND), Set.of(ETokenType.EQEQ, ETokenType.NOTEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.MOD), Set.of(ETokenType.NOT, ETokenType.COMP, ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.POWER));

    public CLikeConditionEvaluator(ELanguage language) {
        this.language = language;
    }

    @Override
    protected ETokenType getAndOperator() {
        return ETokenType.ANDAND;
    }

    @Override
    protected ETokenType getOrOperator() {
        return ETokenType.OROR;
    }

    @Override
    protected ETokenType getClosingBracketType() {
        return ETokenType.RPAREN;
    }

    @Override
    protected ETokenType getOpeningBracketType() {
        return ETokenType.LPAREN;
    }

    @Override
    protected boolean isEqualOperator(ETokenType operator) {
        return operator == ETokenType.EQEQ;
    }

    @Override
    protected boolean isNotEqualOperator(ETokenType operator) {
        return operator == ETokenType.NOTEQ;
    }

    @Override
    public Set<ETokenType> getBooleanOperators() {
        return Set.of(CLikeConditionEvaluator.getNegationOperator(), this.getAndOperator(), this.getOrOperator(), ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ);
    }

    @Override
    public IConditionTreeNode castToBoolean(IConditionTreeNode originalNode, ExpressionTreeNode expression) {
        if (!expression.isLiteral() || expression.expression.size() != 1) {
            return originalNode;
        }
        IToken literalToken = expression.getExpression().get(0);
        ETokenType tokenType = literalToken.getType();
        switch (tokenType) {
            case INTEGER_LITERAL: 
            case FLOATING_POINT_LITERAL: {
                if (literalToken.getText().matches(ZERO_REPRESENTATION)) {
                    return new ConditionTreeNodeFalse();
                }
                return new ConditionTreeNodeTrue();
            }
            case NULLPTR: 
            case NULL: {
                return new ConditionTreeNodeFalse();
            }
        }
        if (tokenType.getTokenClass() == ETokenType.ETokenClass.LITERAL) {
            return new ConditionTreeNodeTrue();
        }
        return originalNode;
    }

    @Override
    public boolean supportsImplicitBooleanCast() {
        return this.language != ELanguage.JAVA;
    }

    @Override
    public IOperatorInformation getOperatorInformation() {
        return new IOperatorInformationFactory.SimpleOperatorInformation(CLIKE_OPERATORS);
    }
}

