/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import us.hebi.matlab.mat.format.BufferAllocator;
import us.hebi.matlab.mat.format.CharEncoding;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5ArrayFlags;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.format.Mat5Subsystem;
import us.hebi.matlab.mat.format.Mat5Tag;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.format.MatCell;
import us.hebi.matlab.mat.format.MatChar;
import us.hebi.matlab.mat.format.MatFunction;
import us.hebi.matlab.mat.format.MatJavaObject;
import us.hebi.matlab.mat.format.MatMatrix;
import us.hebi.matlab.mat.format.MatObjectStruct;
import us.hebi.matlab.mat.format.MatOpaque;
import us.hebi.matlab.mat.format.MatSparseCSC;
import us.hebi.matlab.mat.format.MatStruct;
import us.hebi.matlab.mat.format.McosFileWrapper;
import us.hebi.matlab.mat.format.McosReference;
import us.hebi.matlab.mat.format.McosRegistry;
import us.hebi.matlab.mat.format.NumberStore;
import us.hebi.matlab.mat.format.UniversalNumberStore;
import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.ObjectStruct;
import us.hebi.matlab.mat.types.Opaque;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sparse;
import us.hebi.matlab.mat.types.Struct;
import us.hebi.matlab.mat.util.Casts;
import us.hebi.matlab.mat.util.Preconditions;
import us.hebi.matlab.mat.util.Tasks;

public class Mat5Reader {
    protected final Source source;
    private int numEntries = 0;
    private long subsysPosition = Long.MIN_VALUE;
    private boolean nextIsSubsys = false;
    private boolean mayFilterNext = false;
    private boolean reducedHeader = false;
    protected EntryFilter filter = null;
    private ExecutorService executorService = null;
    private boolean processSubsystem = true;
    private int maxInflateBufferSize = 2048;
    protected McosRegistry mcos = new McosRegistry();
    protected BufferAllocator bufferAllocator = Mat5.getDefaultBufferAllocator();

    public Mat5Reader setEntryFilter(EntryFilter filter) {
        this.filter = Preconditions.checkNotNull(filter);
        return this;
    }

    public Mat5Reader enableConcurrentDecompression(ExecutorService executorService) {
        this.executorService = Preconditions.checkNotNull(executorService);
        return this;
    }

    public Mat5Reader setBufferAllocator(BufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
        return this;
    }

    public Mat5Reader setReducedHeader(boolean reducedHeader) {
        this.reducedHeader = reducedHeader;
        return this;
    }

    public Mat5Reader setMaxInflateBufferSize(int maxInflateBufferSize) {
        this.maxInflateBufferSize = maxInflateBufferSize;
        return this;
    }

    public Mat5Reader disableSubsystemProcessing() {
        this.processSubsystem = false;
        return this;
    }

    Mat5Reader setMcosRegistry(McosRegistry registry) {
        this.mcos = Preconditions.checkNotNull(registry);
        return this;
    }

    public final Mat5File readMat() throws IOException {
        try {
            long start = this.source.getPosition();
            Mat5File matFile = this.readMatHeader();
            this.subsysPosition = start + matFile.getSubsysOffset();
            for (Future<MatFile.Entry> task : this.readMatContent()) {
                MatFile.Entry entry = task.get();
                if (entry == null) continue;
                matFile.addEntry(entry);
            }
            if (matFile.getSubsystem() != null && this.processSubsystem) {
                ((Mat5Subsystem)matFile.getSubsystem().getValue()).processReferences(this.mcos);
            }
            return matFile;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Mat5File readMatHeader() throws IOException {
        this.source.order(ByteOrder.nativeOrder());
        Mat5File matFile = this.reducedHeader ? Mat5File.readReducedFileHeader(this.source) : Mat5File.readFileHeader(this.source);
        this.source.order(matFile.getByteOrder());
        return matFile;
    }

    private List<Future<MatFile.Entry>> readMatContent() throws IOException {
        ArrayList<Future<MatFile.Entry>> content = new ArrayList<Future<MatFile.Entry>>();
        Mat5Tag tag = Mat5Tag.readTagOrNull(this.source);
        while (tag != null) {
            content.add(this.readEntry(tag));
            tag = Mat5Tag.readTagOrNull(this.source);
        }
        return content;
    }

    private Mat5Tag readTag() throws IOException {
        return Mat5Tag.readTag(this.source);
    }

    private Future<MatFile.Entry> readEntry(Mat5Tag tag) throws IOException {
        boolean atSubsys;
        Preconditions.checkArgument(tag.getNumBytes() != 0, "Root element contains no data");
        long expectedEnd = this.source.getPosition() + (long)tag.getNumBytes() + (long)tag.getPadding();
        if (!this.reducedHeader) {
            atSubsys = this.subsysPosition == this.source.getPosition() - 8L;
        } else {
            ++this.numEntries;
            atSubsys = this.numEntries == 2;
        }
        try {
            if (tag.getType() == Mat5Type.Matrix) {
                Future<MatFile.Entry> future = Tasks.wrapAsFuture(this.atRoot(atSubsys).readEntryWithoutTag(tag));
                return future;
            }
            if (tag.getType() == Mat5Type.Compressed) {
                int bufferSize = tag.getNumBytes() * 2;
                if (bufferSize > this.maxInflateBufferSize || bufferSize < 0) {
                    bufferSize = this.maxInflateBufferSize;
                }
                final Source inflated = this.source.readInflated(tag.getNumBytes(), bufferSize);
                Tasks.IoTask<MatFile.Entry> task = new Tasks.IoTask<MatFile.Entry>(){

                    @Override
                    public MatFile.Entry call() throws IOException {
                        try {
                            MatFile.Entry entry = Mat5Reader.this.createChildReader(inflated).atRoot(atSubsys).readEntry();
                            return entry;
                        }
                        finally {
                            inflated.close();
                        }
                    }
                };
                boolean runAsync = !this.source.isMutatedByChildren() && this.executorService != null;
                Future<MatFile.Entry> future = runAsync ? this.executorService.submit(task) : Tasks.wrapAsFuture(task.call());
                return future;
            }
            throw Mat5Reader.readError("Expected 'Compressed' or 'Matrix' tag. Found: %s", new Object[]{tag.getType()});
        }
        finally {
            long remaining = expectedEnd - this.source.getPosition();
            if (remaining > 0L) {
                this.source.skip(remaining);
            }
        }
    }

    private Mat5Reader atRoot(boolean atSubsys) {
        this.nextIsSubsys = atSubsys;
        this.mayFilterNext = true;
        return this;
    }

    private boolean isAccepted(EntryHeader header) {
        try {
            if (this.filter == null || !this.mayFilterNext || this.nextIsSubsys) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.filter.isAccepted(header);
            return bl;
        }
        finally {
            this.mayFilterNext = false;
        }
    }

    protected Array readNestedArray() throws IOException {
        return this.readEntry().getValue();
    }

    private MatFile.Entry readEntry() throws IOException {
        Mat5Tag tag = this.readTagWithExpectedType(Mat5Type.Matrix);
        if (tag.getNumBytes() == 0) {
            return new MatFile.Entry("", false, Mat5.EMPTY_MATRIX);
        }
        return this.readEntryWithoutTag(tag);
    }

    private MatFile.Entry readEntryWithoutTag(Mat5Tag tag) throws IOException {
        long expectedBytes = Casts.uint32(tag.getNumBytes());
        if (expectedBytes > Integer.MAX_VALUE) {
            String warning = String.format("[MFL] encountered illegal entry larger than 2GB: %.1fGB.", (double)expectedBytes / 1024.0 / 1024.0 / 1024.0);
            System.err.println(warning);
        }
        long start = this.source.getPosition();
        MatFile.Entry value = this.readEntryWithoutTag();
        long numBytes = this.source.getPosition() - start;
        if (expectedBytes == numBytes || value == null) {
            return value;
        }
        throw Mat5Reader.readError("Specified matrix tag does not match content size. Tag: %d, Content: %d", tag.getNumBytes(), numBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatFile.Entry readEntryWithoutTag() throws IOException {
        Array array;
        int[] arrayFlags = this.readTagWithExpectedType(Mat5Type.UInt32).readAsInts();
        if (arrayFlags.length != 2) {
            throw Mat5Reader.readError("Unexpected size of array flags. Expected %d, Found %d", 2, arrayFlags.length);
        }
        MatlabType type = Mat5ArrayFlags.getType(arrayFlags);
        if (type == MatlabType.Opaque) {
            this.mayFilterNext = false;
            return this.readOpaque(arrayFlags);
        }
        int[] dimensions = this.readTagWithExpectedType(Mat5Type.Int32).readAsInts();
        if (dimensions.length < 2) {
            throw Mat5Reader.readError("Expected at least 2 dimensions. Found %d", dimensions.length);
        }
        String name = Mat5Reader.readAsAscii(this.readTagWithExpectedType(Mat5Type.Int8));
        EntryHeader header = new EntryHeader(arrayFlags, type, dimensions, name);
        if (!this.isAccepted(header)) {
            return null;
        }
        if (this.nextIsSubsys) {
            try {
                MatFile.Entry entry = new MatFile.Entry(name, header.isGlobal(), this.readSubsystem(header));
                return entry;
            }
            finally {
                this.nextIsSubsys = false;
            }
        }
        switch (header.getType()) {
            case Double: 
            case Single: 
            case Int8: 
            case UInt8: 
            case Int16: 
            case UInt16: 
            case Int32: 
            case UInt32: 
            case Int64: 
            case UInt64: {
                array = this.readNumerical(header);
                break;
            }
            case Sparse: {
                array = this.readSparse(header);
                break;
            }
            case Character: {
                array = this.readChar(header);
                break;
            }
            case Cell: {
                array = this.readCell(header);
                break;
            }
            case Structure: {
                array = this.readStruct(header);
                break;
            }
            case Object: {
                array = this.readObject(header);
                break;
            }
            case Function: {
                array = this.readFunctionHandle(header);
                break;
            }
            case Opaque: {
                throw new AssertionError((Object)"Should not get here");
            }
            default: {
                throw Mat5Reader.readError("Found unsupported type: %s", new Object[]{type});
            }
        }
        return new MatFile.Entry(name, header.isGlobal(), array);
    }

    private Array readSubsystem(EntryHeader header) throws IOException {
        if (header.isComplex()) {
            throw Mat5Reader.readError("Subsystem can't be complex", new Object[0]);
        }
        if (header.getType() != MatlabType.UInt8) {
            throw Mat5Reader.readError("Unexpected Subsystem class type. Expected: %s, Found %s", new Object[]{Mat5Type.UInt8, header.getType()});
        }
        ByteBuffer buffer = this.readAsByteBuffer(this.readTagWithExpectedType(Mat5Type.UInt8));
        return new Mat5Subsystem(header.getDimensions(), buffer, this.bufferAllocator);
    }

    private Array readNumerical(EntryHeader header) throws IOException {
        NumberStore real = this.readAsNumberStore(this.readTag());
        NumberStore imaginary = null;
        if (header.isComplex()) {
            imaginary = this.readAsNumberStore(this.readTag());
        }
        return this.createMatrix(header.getDimensions(), header.getType(), header.isLogical(), real, imaginary);
    }

    private Array readSparse(EntryHeader header) throws IOException {
        NumberStore rowIndices = this.readAsNumberStore(this.readTagWithExpectedType(Mat5Type.Int32));
        if (header.getNzMax() == 1 && rowIndices.getNumElements() == 0) {
            rowIndices = new UniversalNumberStore(Mat5Type.Int32, this.bufferAllocator.allocate(4), this.bufferAllocator);
        }
        NumberStore colIndices = this.readAsNumberStore(this.readTagWithExpectedType(Mat5Type.Int32));
        NumberStore real = this.readAsNumberStore(this.readTag());
        NumberStore imaginary = null;
        if (header.isComplex()) {
            imaginary = this.readAsNumberStore(this.readTag());
        }
        return this.createSparse(header.getDimensions(), header.isLogical(), header.getNzMax(), real, imaginary, rowIndices, colIndices);
    }

    private Array readChar(EntryHeader header) throws IOException {
        Mat5Tag tag = this.readTag();
        CharEncoding encoding = tag.getType().getCharEncoding();
        CharEncoding.CloseableCharBuffer buffer = tag.getNumBytes() > 0 ? encoding.readCharBuffer(this.source, tag.getNumBytes(), this.bufferAllocator) : CharEncoding.CloseableCharBuffer.allocate(this.bufferAllocator, header.getNumElements(), ' ');
        this.source.skip(tag.getPadding());
        return this.createChar(header.getDimensions(), encoding, buffer);
    }

    protected Array readCell(EntryHeader header) throws IOException {
        Array[] contents = new Array[header.getNumElements()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = this.readNestedArray();
        }
        return this.createCell(header.getDimensions(), contents);
    }

    private Array readStruct(EntryHeader header) throws IOException {
        return this.readStructOrObject(header, null);
    }

    private Array readObject(EntryHeader header) throws IOException {
        String className = Mat5Reader.readAsAscii(this.readTagWithExpectedType(Mat5Type.Int8));
        return this.readStructOrObject(header, className);
    }

    private Array readStructOrObject(EntryHeader header, String objectClassName) throws IOException {
        int[] result = this.readTagWithExpectedType(Mat5Type.Int32).readAsInts();
        Preconditions.checkArgument(result.length == 1, "Incorrect number of values for max field name length");
        int maxLength = result[0];
        byte[] buffer = this.readTagWithExpectedType(Mat5Type.Int8).readAsBytes();
        int numFields = maxLength == 0 ? 0 : buffer.length / maxLength;
        String[] names = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            names[i] = CharEncoding.parseAsciiString(buffer, i * maxLength, maxLength);
        }
        Array[][] values = this.readValues(header, numFields, names);
        if (objectClassName == null) {
            return this.createStruct(header.getDimensions(), names, values);
        }
        return this.createObject(header.getDimensions(), objectClassName, names, values);
    }

    protected Array[][] readValues(EntryHeader header, int numFields, String[] names) throws IOException {
        int numElements = header.getNumElements();
        Array[][] values = new Array[numFields][numElements];
        for (int i = 0; i < numElements; ++i) {
            for (int field = 0; field < numFields; ++field) {
                values[field][i] = this.readNestedArray();
            }
        }
        return values;
    }

    private Array readFunctionHandle(EntryHeader header) throws IOException {
        Struct content = (Struct)this.readNestedArray();
        return new MatFunction(content);
    }

    private MatFile.Entry readOpaque(int[] arrayFlags) throws IOException {
        boolean isGlobal = Mat5ArrayFlags.isGlobal(arrayFlags);
        String name = Mat5Reader.readAsAscii(this.readTagWithExpectedType(Mat5Type.Int8));
        String objectType = Mat5Reader.readAsAscii(this.readTagWithExpectedType(Mat5Type.Int8));
        String className = Mat5Reader.readAsAscii(this.readTagWithExpectedType(Mat5Type.Int8));
        Array content = this.readNestedArray();
        return new MatFile.Entry(name, isGlobal, this.createOpaque(objectType, className, content));
    }

    private static String readAsAscii(Mat5Tag tag) throws IOException {
        return CharEncoding.parseAsciiString(tag.readAsBytes());
    }

    private NumberStore readAsNumberStore(Mat5Tag tag) throws IOException {
        return new UniversalNumberStore(tag.getType(), this.readAsByteBuffer(tag), this.bufferAllocator);
    }

    private ByteBuffer readAsByteBuffer(Mat5Tag tag) throws IOException {
        ByteBuffer buffer = this.bufferAllocator.allocate(tag.getNumBytes());
        buffer.order(this.source.order());
        this.source.readByteBuffer(buffer);
        this.source.skip(tag.getPadding());
        buffer.rewind();
        return buffer;
    }

    protected Mat5Tag readTagWithExpectedType(Mat5Type expected) throws IOException {
        Mat5Tag tag = this.readTag();
        if (tag.getType() != expected) {
            throw Mat5Reader.readError("Encountered unexpected tag. Expected %s, Found %s", new Object[]{expected, tag.getType()});
        }
        return tag;
    }

    static IOException readError(String format, Object ... args) {
        return new IOException(String.format(format, args));
    }

    protected Mat5Reader createChildReader(Source source) {
        Mat5Reader reader = new Mat5Reader(source);
        reader.filter = this.filter;
        reader.mcos = this.mcos;
        reader.bufferAllocator = this.bufferAllocator;
        return reader;
    }

    private Matrix createMatrix(int[] dimensions, MatlabType type, boolean logical, NumberStore real, NumberStore imaginary) {
        return new MatMatrix(dimensions, type, logical, real, imaginary);
    }

    private Sparse createSparse(int[] dimensions, boolean logical, int nzMax, NumberStore real, NumberStore imaginary, NumberStore rowIndices, NumberStore colIndices) {
        return new MatSparseCSC(dimensions, logical, nzMax, real, imaginary, rowIndices, colIndices);
    }

    private Char createChar(int[] dims, CharEncoding encoding, CharEncoding.CloseableCharBuffer buffer) {
        return new MatChar(dims, encoding, buffer);
    }

    protected Cell createCell(int[] dims, Array[] contents) {
        return new MatCell(dims, contents);
    }

    private Struct createStruct(int[] dims, String[] names, Array[][] values) {
        return new MatStruct(dims, names, values);
    }

    private ObjectStruct createObject(int[] dims, String className, String[] names, Array[][] values) {
        return new MatObjectStruct(dims, className, names, values);
    }

    private Opaque createOpaque(String objectType, String className, Array content) {
        if ("java".equals(objectType)) {
            return new MatJavaObject(className, content);
        }
        if ("MCOS".equals(objectType)) {
            if ("FileWrapper__".equals(className)) {
                return new McosFileWrapper(objectType, className, content, this.source.order());
            }
            return this.mcos.register(McosReference.parseOpaque(objectType, className, content));
        }
        return new MatOpaque(objectType, className, content);
    }

    protected Mat5Reader(Source source) {
        this.source = Preconditions.checkNotNull(source, "Source can't be empty");
    }

    public static interface EntryFilter {
        public boolean isAccepted(EntryHeader var1);
    }

    public static class EntryHeader {
        final int[] arrayFlags;
        final MatlabType type;
        final int[] dimensions;
        final String name;

        public int getNumElements() {
            return AbstractArray.getNumElements(this.dimensions);
        }

        public MatlabType getType() {
            return this.type;
        }

        public int[] getDimensions() {
            return this.dimensions;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLogical() {
            return Mat5ArrayFlags.isLogical(this.arrayFlags);
        }

        public boolean isComplex() {
            return Mat5ArrayFlags.isComplex(this.arrayFlags);
        }

        public boolean isGlobal() {
            return Mat5ArrayFlags.isGlobal(this.arrayFlags);
        }

        public int getNzMax() {
            return Mat5ArrayFlags.getNzMax(this.arrayFlags);
        }

        private EntryHeader(int[] arrayFlags, MatlabType type, int[] dimensions, String name) {
            this.arrayFlags = arrayFlags;
            this.type = type;
            this.dimensions = dimensions;
            this.name = name;
        }

        public String toString() {
            return "EntryHeader{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", dimensions=" + Arrays.toString(this.dimensions) + (this.isGlobal() ? ", global" : "") + (this.isLogical() ? ", logical" : "") + (this.isComplex() ? ", complex" : "") + '}';
        }
    }
}

