/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.util.Casts;

public abstract class AbstractMatrixBase
extends AbstractArray
implements Matrix {
    protected AbstractMatrixBase(int[] dims) {
        super(dims);
    }

    protected long orLogical(long value) {
        if (this.isLogical()) {
            return value != 0L ? 1L : 0L;
        }
        return value;
    }

    protected double orLogical(double value) {
        if (this.isLogical()) {
            return value != 0.0 ? 1.0 : 0.0;
        }
        return value;
    }

    @Override
    public abstract long getLong(int var1);

    @Override
    public abstract void setLong(int var1, long var2);

    @Override
    public abstract double getDouble(int var1);

    @Override
    public abstract void setDouble(int var1, double var2);

    @Override
    public abstract long getImaginaryLong(int var1);

    @Override
    public abstract void setImaginaryLong(int var1, long var2);

    @Override
    public abstract double getImaginaryDouble(int var1);

    @Override
    public abstract void setImaginaryDouble(int var1, double var2);

    @Override
    public boolean getBoolean(int index) {
        return Casts.logical(this.getDouble(index));
    }

    @Override
    public byte getByte(int index) {
        return Casts.int8(this.getLong(index));
    }

    @Override
    public short getShort(int index) {
        return Casts.int16(this.getLong(index));
    }

    @Override
    public int getInt(int index) {
        return Casts.int32(this.getLong(index));
    }

    @Override
    public float getFloat(int index) {
        return Casts.single(this.getDouble(index));
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.setLong(index, (long)Casts.int8(value));
    }

    @Override
    public void setByte(int index, byte value) {
        this.setLong(index, (long)value);
    }

    @Override
    public void setShort(int index, short value) {
        this.setLong(index, (long)value);
    }

    @Override
    public void setInt(int index, int value) {
        this.setLong(index, (long)value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setDouble(index, (double)value);
    }

    @Override
    public byte getImaginaryByte(int index) {
        return Casts.int8(this.getImaginaryLong(index));
    }

    @Override
    public short getImaginaryShort(int index) {
        return Casts.int16(this.getImaginaryLong(index));
    }

    @Override
    public int getImaginaryInt(int index) {
        return Casts.int32(this.getImaginaryLong(index));
    }

    @Override
    public float getImaginaryFloat(int index) {
        return Casts.single(this.getImaginaryDouble(index));
    }

    @Override
    public void setImaginaryByte(int index, byte value) {
        this.setImaginaryLong(index, (long)value);
    }

    @Override
    public void setImaginaryShort(int index, short value) {
        this.setImaginaryLong(index, (long)value);
    }

    @Override
    public void setImaginaryInt(int index, int value) {
        this.setImaginaryLong(index, (long)value);
    }

    @Override
    public void setImaginaryFloat(int index, float value) {
        this.setImaginaryDouble(index, (double)value);
    }

    @Override
    public final boolean getBoolean(int row, int col) {
        return this.getBoolean(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final byte getByte(int row, int col) {
        return this.getByte(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final short getShort(int row, int col) {
        return this.getShort(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final int getInt(int row, int col) {
        return this.getInt(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final long getLong(int row, int col) {
        return this.getLong(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final float getFloat(int row, int col) {
        return this.getFloat(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final double getDouble(int row, int col) {
        return this.getDouble(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final void setBoolean(int row, int col, boolean value) {
        this.setBoolean(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setByte(int row, int col, byte value) {
        this.setByte(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setShort(int row, int col, short value) {
        this.setShort(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setInt(int row, int col, int value) {
        this.setInt(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setLong(int row, int col, long value) {
        this.setLong(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setFloat(int row, int col, float value) {
        this.setFloat(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setDouble(int row, int col, double value) {
        this.setDouble(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final boolean getBoolean(int[] indices) {
        return this.getBoolean(this.getColumnMajorIndex(indices));
    }

    @Override
    public final byte getByte(int[] indices) {
        return this.getByte(this.getColumnMajorIndex(indices));
    }

    @Override
    public final short getShort(int[] indices) {
        return this.getShort(this.getColumnMajorIndex(indices));
    }

    @Override
    public final int getInt(int[] indices) {
        return this.getInt(this.getColumnMajorIndex(indices));
    }

    @Override
    public final long getLong(int[] indices) {
        return this.getLong(this.getColumnMajorIndex(indices));
    }

    @Override
    public final float getFloat(int[] indices) {
        return this.getFloat(this.getColumnMajorIndex(indices));
    }

    @Override
    public final double getDouble(int[] indices) {
        return this.getDouble(this.getColumnMajorIndex(indices));
    }

    @Override
    public final void setBoolean(int[] indices, boolean value) {
        this.setBoolean(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setByte(int[] indices, byte value) {
        this.setByte(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setShort(int[] indices, short value) {
        this.setShort(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setInt(int[] indices, int value) {
        this.setInt(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setLong(int[] indices, long value) {
        this.setLong(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setFloat(int[] indices, float value) {
        this.setFloat(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setDouble(int[] indices, double value) {
        this.setDouble(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final byte getImaginaryByte(int row, int col) {
        return this.getImaginaryByte(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final short getImaginaryShort(int row, int col) {
        return this.getImaginaryShort(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final int getImaginaryInt(int row, int col) {
        return this.getImaginaryInt(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final long getImaginaryLong(int row, int col) {
        return this.getImaginaryLong(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final float getImaginaryFloat(int row, int col) {
        return this.getImaginaryFloat(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final double getImaginaryDouble(int row, int col) {
        return this.getImaginaryDouble(this.getColumnMajorIndex(row, col));
    }

    @Override
    public final void setImaginaryByte(int row, int col, byte value) {
        this.setImaginaryByte(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setImaginaryShort(int row, int col, short value) {
        this.setImaginaryShort(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setImaginaryInt(int row, int col, int value) {
        this.setImaginaryInt(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setImaginaryLong(int row, int col, long value) {
        this.setImaginaryLong(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setImaginaryFloat(int row, int col, float value) {
        this.setImaginaryFloat(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final void setImaginaryDouble(int row, int col, double value) {
        this.setImaginaryDouble(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public final byte getImaginaryByte(int[] indices) {
        return this.getImaginaryByte(this.getColumnMajorIndex(indices));
    }

    @Override
    public final short getImaginaryShort(int[] indices) {
        return this.getImaginaryShort(this.getColumnMajorIndex(indices));
    }

    @Override
    public final int getImaginaryInt(int[] indices) {
        return this.getImaginaryInt(this.getColumnMajorIndex(indices));
    }

    @Override
    public final long getImaginaryLong(int[] indices) {
        return this.getImaginaryLong(this.getColumnMajorIndex(indices));
    }

    @Override
    public final float getImaginaryFloat(int[] indices) {
        return this.getImaginaryFloat(this.getColumnMajorIndex(indices));
    }

    @Override
    public final double getImaginaryDouble(int[] indices) {
        return this.getImaginaryDouble(this.getColumnMajorIndex(indices));
    }

    @Override
    public final void setImaginaryByte(int[] indices, byte value) {
        this.setImaginaryByte(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setImaginaryShort(int[] indices, short value) {
        this.setImaginaryShort(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setImaginaryInt(int[] indices, int value) {
        this.setImaginaryInt(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setImaginaryLong(int[] indices, long value) {
        this.setImaginaryLong(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setImaginaryFloat(int[] indices, float value) {
        this.setImaginaryFloat(this.getColumnMajorIndex(indices), value);
    }

    @Override
    public final void setImaginaryDouble(int[] indices, double value) {
        this.setImaginaryDouble(this.getColumnMajorIndex(indices), value);
    }
}

