/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metadata.abap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass
public enum EAbapProgramType {
    NOT_ASSIGNED(' ', "Not assigned"),
    UNKNOWN_TYPE('~', "Unknown"),
    BEHAVIOR_DEFINITION('B', "Behavior definition"),
    FUNCTION_GROUP('F', "Function pool"),
    INCLUDE_PROGRAM('I', "Include program"),
    INTERFACE_POOL('J', "Interface pool"),
    CLASS_POOL('K', "Class pool"),
    MODULE_POOL('M', "Module pool"),
    DATABASE_PROCEDURE_PROXY('Q', "Database procedure proxy"),
    SUBROUTINE_POOL('S', "Subroutine pool"),
    TYPE_POOL('T', "Type pool"),
    XSLT_OR_ST_PROGRAM_TRANSFORMATION('X', "Program transformation"),
    EXECUTABLE_PROGRAM('1', "Executable program");

    private static final String TYPE_VALUE_PROPERTY = "typeValue";
    private static final String HUMAN_READABLE_NAME_PROPERTY = "humanReadableName";
    @JsonProperty(value="typeValue")
    private final char typeValue;
    @JsonProperty(value="humanReadableName")
    private final String humanReadableName;

    @JsonCreator
    private EAbapProgramType(char typeValue, String humanReadableName) {
        this.typeValue = typeValue;
        this.humanReadableName = humanReadableName;
    }

    public static EAbapProgramType getProgramTypeFromValue(char typeValue) {
        for (EAbapProgramType programType : EAbapProgramType.values()) {
            if (programType == UNKNOWN_TYPE || programType.typeValue != typeValue) continue;
            return programType;
        }
        return UNKNOWN_TYPE;
    }

    public char getTypeValue() {
        return this.typeValue;
    }

    public static CounterSet<String> toMetric(EAbapProgramType type) {
        if (type == null || type == NOT_ASSIGNED) {
            return new CounterSet((Object)EAbapProgramType.NOT_ASSIGNED.humanReadableName, 1);
        }
        return new CounterSet((Object)(type.humanReadableName + " (" + type.typeValue + ")"), 1);
    }
}

