/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PrioritizableTestBase
implements IPrioritizableTests,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    protected final Set<MethodId> coveredChangedMethods = new HashSet<MethodId>();
    @JsonIgnore
    private int currentAdditionallyCoveredMethodsCount = 0;
    @JsonIgnore
    protected Set<MethodId> coveredMethods = null;
    @JsonProperty(value="durationInMs")
    protected @Nullable Long durationInMs = null;
    @JsonProperty(value="currentScore")
    private double currentScore;
    @JsonProperty(value="numberOfAdditionallyCoveredMethods")
    private int numberOfAdditionallyCoveredMethods = 0;
    @JsonProperty(value="rank")
    private Integer rank;
    @JsonIgnore
    private Set<MethodId> changedMethodLocations = Collections.emptySet();

    public PrioritizableTestBase() {
    }

    public PrioritizableTestBase(Set<MethodId> changedMethodLocations) {
        this.changedMethodLocations = changedMethodLocations;
    }

    @Override
    public void initAdditionallyCoveredMethods(Set<MethodId> methodsToTest) {
        Sets.SetView intersection = Sets.intersection(this.getCoveredMethods(), methodsToTest);
        this.coveredChangedMethods.addAll((Collection<MethodId>)intersection);
        this.currentAdditionallyCoveredMethodsCount = this.coveredChangedMethods.size();
    }

    @Override
    public void resetCurrentAdditionallyCoveredMethods() {
        this.currentAdditionallyCoveredMethodsCount = this.coveredChangedMethods.size();
    }

    @Override
    public void removeFromCurrentAdditionallyCoveredMethods(Collection<MethodId> methodsToRemove) {
        for (MethodId methodId : methodsToRemove) {
            if (!this.coveredChangedMethods.contains(methodId)) continue;
            --this.currentAdditionallyCoveredMethodsCount;
        }
    }

    @Override
    public long getNumberOfCoveredMethods() {
        return this.getCoveredMethods().size();
    }

    @Override
    public long getNumberOfCurrentAdditionallyCoveredMethods() {
        return this.currentAdditionallyCoveredMethodsCount;
    }

    @Override
    public Set<MethodId> getCoveredChangedMethods() {
        return this.coveredChangedMethods;
    }

    @Override
    public void setCurrentScore(double currentScore) {
        this.currentScore = currentScore;
    }

    public Integer getRank() {
        return this.rank;
    }

    @Override
    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public double getCurrentScore() {
        return this.currentScore;
    }

    @Override
    public Set<MethodId> getChangedMethodLocations() {
        return this.changedMethodLocations;
    }

    @Override
    public void incrementNumberOfAdditionallyCoveredMethods() {
        ++this.numberOfAdditionallyCoveredMethods;
    }

    public int getNumberOfAdditionallyCoveredMethods() {
        return this.numberOfAdditionallyCoveredMethods;
    }
}

