/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.apple.idms;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.apple.AppleIdmsA3AuthOption;
import com.teamscale.core.authenticate.apple.AppleIdmsAppIdentification;
import com.teamscale.core.authenticate.apple.AppleIdmsAppIdentificationOption;
import com.teamscale.core.authenticate.apple.EAppleEnvironment;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.apple.idms.IAppleIdmsApi;
import com.teamscale.index.apple.idms.model.AppleA3Token;
import com.teamscale.index.apple.idms.model.AppleA3TokenRequest;
import java.time.Duration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class A3Authenticator {
    private static final String SEPARATOR = "#-#";
    private final AccessTokenIndex accessTokenIndex;
    private final AppleIdmsAppIdentification teamscaleInIdms;
    private final AppleIdmsA3AuthOption a3Option;

    private A3Authenticator(AccessTokenIndex accessTokenIndex, AppleIdmsAppIdentification teamscaleIdentificationInIdmsOption, AppleIdmsA3AuthOption a3Option) {
        this.accessTokenIndex = accessTokenIndex;
        this.a3Option = a3Option;
        this.teamscaleInIdms = teamscaleIdentificationInIdmsOption;
    }

    public static A3Authenticator create(AccessTokenIndex accessTokenIndex, ServerOptionIndex serverOptionIndex, @Nullable String appleA3MultiOptionIdentifier) throws StorageException {
        AppleIdmsA3AuthOption appleIdmsA3AuthOption = A3Authenticator.loadA3AuthOption(serverOptionIndex, appleA3MultiOptionIdentifier);
        CCSMAssert.isNotNull((Object)appleIdmsA3AuthOption, (String)"Apple IdMS configuration invalid. The A3 option '%s' could not be loaded from the server options.".formatted(appleA3MultiOptionIdentifier));
        AppleIdmsAppIdentification identificationOption = A3Authenticator.loadIdmsIdentificationOption(serverOptionIndex, appleIdmsA3AuthOption.getConfiguredEnvironment());
        return new A3Authenticator(accessTokenIndex, identificationOption, appleIdmsA3AuthOption);
    }

    private static AccessTokenIndex.AccessToken requestNewTokenFromIdms(AppleIdmsAppIdentification teamscaleInIdms, AppleIdmsA3AuthOption a3Option) throws ServiceCallException {
        IAppleIdmsApi idms = IAppleIdmsApi.create(a3Option.getConfiguredEnvironment());
        AppleA3TokenRequest tokenRequest = AppleA3TokenRequest.from(teamscaleInIdms, a3Option);
        AppleA3Token appleA3Token = (AppleA3Token)Retrofit.executeServiceCall(idms.generateA3Token(tokenRequest)).orElseThrow(() -> new ServiceCallException("Could not request A3 token"));
        return appleA3Token.toAccessToken();
    }

    private static String makeTokenMapKey(AppleIdmsA3AuthOption a3AuthOption) {
        return a3AuthOption.getOtherApplicationId() + SEPARATOR + a3AuthOption.context + SEPARATOR + a3AuthOption.personId + SEPARATOR + a3AuthOption.isUat;
    }

    private static AppleIdmsAppIdentification loadIdmsIdentificationOption(ServerOptionIndex serverOptionIndex, EAppleEnvironment environment) throws StorageException {
        AppleIdmsAppIdentificationOption option = (AppleIdmsAppIdentificationOption)ServerOptionRegistry.getInstance().getOption(EOptionType.SERVER.name().toLowerCase(), "apple.idms.application.identification", null, AppleIdmsAppIdentificationOption.class, (OptionIndexBase)serverOptionIndex);
        CCSMAssert.isNotNull((Object)option, (String)"Apple IdMS configuration invalid. The IdMS identification option could not be loaded from the server options.");
        return option.getValuesForEnvironment(environment);
    }

    private static @Nullable AppleIdmsA3AuthOption loadA3AuthOption(ServerOptionIndex serverOptionIndex, String appleA3MultiOptionIdentifier) throws StorageException {
        return (AppleIdmsA3AuthOption)ServerOptionRegistry.getInstance().getOption(EOptionType.SERVER.name().toLowerCase(), "apple.idms.a3.auth", appleA3MultiOptionIdentifier, AppleIdmsA3AuthOption.class, (OptionIndexBase)serverOptionIndex);
    }

    public String requestA3Token() throws ServiceCallException, StorageException {
        String a3OptionKey = A3Authenticator.makeTokenMapKey(this.a3Option);
        return this.accessTokenIndex.getOrCreateToken(a3OptionKey, Duration.ofHours(1L), () -> A3Authenticator.requestNewTokenFromIdms(this.teamscaleInIdms, this.a3Option));
    }

    public long getTeamscaleAppleIdmsAppId() {
        return this.teamscaleInIdms.applicationId();
    }

    public String getRadarBaseUrl() {
        String baseUrlForTesting = this.a3Option.getRadarBaseUrlForTesting();
        if (baseUrlForTesting != null) {
            return baseUrlForTesting;
        }
        return this.a3Option.getConfiguredEnvironment().getRadarBaseUrl();
    }

    public @Nullable String getA3IdmsPersonId() {
        return this.a3Option.personId;
    }
}

