/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.assessment.ComponentOverlapping;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.scope.ComponentNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TypeComponentMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<String> unmatchedTypes = new HashSet<String>();
    private final ListMap<String, String> redundantIncludePatterns = new ListMap();
    private final ComponentOverlapping componentOverlaps = new ComponentOverlapping();
    private final ListMap<String, Integer> numberOfMatches = new ListMap();
    private final SetMap<String, String> typesToComponents = new SetMap();
    private final SetMap<String, String> componentsToTypes = new SetMap();
    private final CounterSet<String> thirdPartyDependencyUsageCounter = new CounterSet();

    public TypeComponentMapping(TypeToComponentMapper.MappingResult result) {
        Object componentNames;
        this.unmatchedTypes.addAll(result.unmatchedTypes());
        this.redundantIncludePatterns.addAll(result.redundantIncludePatterns());
        this.numberOfMatches.addAll(result.numberOfMatches());
        this.componentOverlaps.addAll(result.componentOverlaps());
        for (Map.Entry entry : result.typesToComponents().entrySet()) {
            componentNames = ((Set)entry.getValue()).stream().map(ComponentNode::getName).collect(Collectors.toSet());
            this.typesToComponents.addAll((Object)((String)entry.getKey()), (Collection)componentNames);
        }
        for (Map.Entry entry : result.componentsToTypes().entrySet()) {
            componentNames = ((ComponentNode)entry.getKey()).getName();
            this.componentsToTypes.addAll(componentNames, (Collection)entry.getValue());
        }
    }

    public Set<String> getUnmatchedTypes() {
        return this.unmatchedTypes;
    }

    public Set<String> getMatchedTypes() {
        return CollectionUtils.asUnmodifiable((Set)this.typesToComponents.getKeys());
    }

    public ListMap<String, String> getRedundantIncludePatterns() {
        return this.redundantIncludePatterns;
    }

    public ComponentOverlapping getComponentOverlaps() {
        return this.componentOverlaps;
    }

    public ListMap<String, Integer> getNumberOfMatches() {
        return this.numberOfMatches;
    }

    public Set<String> getMappedTypes(ComponentNode component) {
        return CollectionUtils.asUnmodifiable((Set)((Set)this.componentsToTypes.getCollectionOrEmpty((Object)component.getName())));
    }

    public @Nullable String getMappedComponentForType(String type) {
        return (String)CollectionUtils.getAny((Iterable)this.typesToComponents.getCollectionOrEmpty((Object)type));
    }

    public void removeType(Set<String> deletedTypes, ListMap<String, Integer> numberOfMatches) {
        this.unmatchedTypes.removeAll(deletedTypes);
        this.thirdPartyDependencyUsageCounter.removeAll(deletedTypes);
        for (String deletedType : deletedTypes) {
            Set components = (Set)this.typesToComponents.getCollectionOrEmpty((Object)deletedType);
            for (String component : components) {
                this.componentsToTypes.remove((Object)component, (Object)deletedType);
            }
            this.typesToComponents.removeCollection((Object)deletedType);
        }
        for (Map.Entry entry : numberOfMatches.entrySet()) {
            List oldValues = (List)this.numberOfMatches.getCollectionOrEmpty((Object)((String)entry.getKey()));
            ArrayList<Integer> newValues = new ArrayList<Integer>();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                Integer newValue = (Integer)oldValues.get(i) - (Integer)((List)entry.getValue()).get(i);
                newValues.add(newValue);
            }
            this.numberOfMatches.removeCollection((Object)((String)entry.getKey()));
            this.numberOfMatches.addAll((Object)((String)entry.getKey()), newValues);
        }
        deletedTypes.forEach(this.componentOverlaps::removeType);
    }

    public void addThirdPartyDependency(Collection<String> types) {
        this.thirdPartyDependencyUsageCounter.incAll(types);
    }

    public Set<String> removeThirdPartyDependency(Collection<String> types) {
        this.thirdPartyDependencyUsageCounter.decAll(types);
        return types.stream().filter(t -> this.thirdPartyDependencyUsageCounter.getValue(t) == 0).collect(Collectors.toSet());
    }

    public void addTypes(TypeToComponentMapper.MappingResult mappingResult) {
        for (Map.Entry entry : mappingResult.typesToComponents().entrySet()) {
            String type = (String)entry.getKey();
            List<String> componentNames = ((Set)entry.getValue()).stream().map(ComponentNode::getName).toList();
            this.typesToComponents.addAll((Object)type, componentNames);
            for (String componentName : componentNames) {
                this.componentsToTypes.add((Object)componentName, (Object)type);
            }
        }
        this.unmatchedTypes.addAll(mappingResult.unmatchedTypes());
        for (Map.Entry entry : mappingResult.numberOfMatches().entrySet()) {
            List oldValues = (List)this.numberOfMatches.getCollectionOrEmpty((Object)((String)entry.getKey()));
            ArrayList<Integer> newValues = new ArrayList<Integer>();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                Integer newValue = (Integer)oldValues.get(i) + (Integer)((List)entry.getValue()).get(i);
                newValues.add(newValue);
            }
            this.numberOfMatches.removeCollection((Object)((String)entry.getKey()));
            this.numberOfMatches.addAll((Object)((String)entry.getKey()), newValues);
        }
        this.componentOverlaps.addAll(mappingResult.componentOverlaps());
    }
}

