/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.scope;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class Constraint {
    private static final String SOURCE_PATTERN_PROPERTY = "sourcePattern";
    private static final String TARGET_PATTERN_PROPERTY = "targetPattern";
    @JsonProperty(value="sourcePattern")
    private final String sourcePattern;
    @JsonProperty(value="targetPattern")
    private final String targetPattern;
    @JsonProperty(value="violatingDependencies")
    private @Nullable List<TypeDependency> violatingDependencies = null;

    @JsonCreator
    public Constraint(@JsonProperty(value="sourcePattern") String sourcePattern, @JsonProperty(value="targetPattern") String targetPattern) {
        CCSMAssert.isNotNull((Object)sourcePattern);
        CCSMAssert.isNotNull((Object)targetPattern);
        this.sourcePattern = sourcePattern;
        this.targetPattern = targetPattern;
    }

    public String getSourcePattern() {
        return this.sourcePattern;
    }

    public String getTargetPattern() {
        return this.targetPattern;
    }

    public void assess(SetMap<String, String> typeDependencies) {
        this.violatingDependencies = new ArrayList<TypeDependency>();
        HashSet<String> sourceTypes = new HashSet<String>();
        HashSet<String> targetTypes = new HashSet<String>();
        Pattern compiledSourcePattern = Pattern.compile(this.sourcePattern);
        Pattern compiledTargetPattern = Pattern.compile(this.targetPattern);
        for (String type : typeDependencies.getKeys()) {
            if (!compiledSourcePattern.matcher(type).matches()) continue;
            sourceTypes.add(type);
        }
        for (String type : (Set)typeDependencies.getValues()) {
            if (!compiledTargetPattern.matcher(type).matches()) continue;
            targetTypes.add(type);
        }
        for (String sourceType : sourceTypes) {
            Set dependencies = (Set)typeDependencies.getCollection((Object)sourceType);
            if (dependencies == null) continue;
            HashSet violations = CollectionUtils.intersectionSet(targetTypes, (Collection[])new Collection[]{dependencies});
            for (String violation : violations) {
                this.violatingDependencies.add(new TypeDependency(sourceType, violation));
            }
        }
    }

    public UnmodifiableList<TypeDependency> getViolatingDependencies() {
        if (this.violatingDependencies == null) {
            throw new IllegalStateException("Must call assess before!");
        }
        return CollectionUtils.asUnmodifiable(this.violatingDependencies);
    }

    public String toString() {
        return this.getSourcePattern() + " -> " + this.getTargetPattern();
    }

    public int hashCode() {
        return this.sourcePattern.hashCode() + 31 * this.targetPattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constraint) {
            Constraint other = (Constraint)obj;
            return this.sourcePattern.equals(other.sourcePattern) && this.targetPattern.equals(other.targetPattern);
        }
        return false;
    }
}

