/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.configuration.RepositoryConfiguration;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.MergedTestInfoIndex;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.MethodIssueSynchronizer;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.TestGapInfoMerger;
import com.teamscale.index.testgap.TestGapSynchronizer;
import com.teamscale.index.testgap.abap.AbapIncludeIndex;
import com.teamscale.index.testgap.abap.AbapIncludeSynchronizer;
import com.teamscale.index.testgap.abap.AbapMethodMappingSynchronizer;
import com.teamscale.index.testgap.abap.AbapMethodMovementSynchronizer;
import com.teamscale.index.testgap.abap.AbapScovMethodMappingIndex;
import com.teamscale.index.testgap.dotnet.DotNetMethodMappingIndex;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import com.teamscale.index.testgap.plsql.HProfMethodMappingIndex;
import com.teamscale.index.testgap.plsql.HProfMethodMappingSynchronizer;
import com.teamscale.index.testgap.trend.NewlyCoveredMethodsIndex;
import com.teamscale.index.testgap.trend.TestCoverageDeltaIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TestGapConfiguration
extends AnalysisConfigurationBase {
    public static final String TGA_ENABLEMENT_OPTION_NAME = "Enable Test Gap Analysis, Pareto Optimization and Test Impact Analysis";
    @ConfigExposed(name="Enable Test Gap Analysis, Pareto Optimization and Test Impact Analysis", description="Enables Test Gap Analysis, Pareto Optimization and Test Impact Analysis")
    private CodeScopeAware<Boolean> enableTga = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    private boolean enableDotNetMethodMapping;
    private boolean enableAbapMethodMapping;
    private boolean enablePlSqlMethodMapping;

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(MethodLastTestedIndex.class);
        proxy.createProjectIndex(MergedTestInfoIndex.class);
        proxy.createProjectIndex(NewlyCoveredMethodsIndex.class);
        proxy.createProjectIndex(TestCoverageDeltaIndex.class);
        proxy.createProjectIndex(ExecutedMethodIndex.class);
        proxy.createProjectIndex(MethodIssueIndex.class);
        proxy.createProjectIndex(AbapScovMethodMappingIndex.class);
        if (this.enableDotNetMethodMapping) {
            proxy.createProjectIndex(DotNetMethodMappingIndex.class);
            proxy.createProjectIndex(DotNetVersionIndex.class);
        }
        if (this.enableAbapMethodMapping) {
            TestGapConfiguration.createAbapMethodMappingInfrastructure(proxy);
        }
        if (this.enablePlSqlMethodMapping) {
            TestGapConfiguration.createPlSqlMethodMappingInfrastructure(proxy);
        }
        proxy.createTrigger(new TriggerBuilder(TestGapSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.EXPENSIVE).setTriggerParameter("enable-tga", this.enableTga));
        proxy.createTrigger(new TriggerBuilder(TestGapInfoMerger.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.EXPENSIVE).setTriggerParameter("enable-tga", this.enableTga));
        proxy.createTrigger(new TriggerBuilder(MethodIssueSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    private static void createPlSqlMethodMappingInfrastructure(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(HProfMethodMappingIndex.class);
        proxy.createTrigger(new TriggerBuilder(HProfMethodMappingSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    private static void createAbapMethodMappingInfrastructure(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(AbapIncludeIndex.class);
        proxy.createTrigger(new TriggerBuilder(AbapIncludeSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(AbapMethodMovementSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(AbapMethodMappingSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.enableAbapMethodMapping = languages.contains(ELanguage.ABAP);
        this.enablePlSqlMethodMapping = tools.contains(EAnalysisTool.PLSQL_HPROF);
        this.enableDotNetMethodMapping = languages.contains(ELanguage.CS) || languages.contains(ELanguage.VB);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        this.autoExpose(template.getCodeScope());
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("enableTga", template.getCodeScope()));
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        ArrayList<Class<? extends AnalysisConfigurationBase>> result = new ArrayList<Class<? extends AnalysisConfigurationBase>>(super.getRequiredConfigurations());
        result.add(RepositoryConfiguration.class);
        return result;
    }
}

