/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dashboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.dashboard.DashboardDescriptor;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;

@NoIndexValueClass
public record DashboardEntryWithPermissions(@JsonProperty UUID id, @JsonProperty String name, @JsonProperty @Nullable String group, @JsonProperty @Nullable String owner, @JsonProperty boolean canWrite, @JsonProperty boolean isMine, @JsonProperty boolean canEditRoles, @JsonProperty boolean isFavorite) {
    public static List<DashboardEntryWithPermissions> resolvePermissions(List<? extends DashboardDescriptor> dashboards, Set<UUID> favorites, ServicePermissions permissions) {
        return CollectionUtils.map(dashboards, dashboard -> {
            PermissionLookup permissionLookup = permissions.getPermissionLookup(EBasicPermissionScope.DASHBOARDS);
            UUID dashboardId = dashboard.getId();
            CCSMAssert.isNotNull((Object)dashboardId, (String)"Dashboard ID may not be null");
            boolean canWrite = permissionLookup.hasPermission(dashboardId.toString(), (Object)EBasicPermission.EDIT);
            boolean canEditRoles = permissionLookup.hasPermission(dashboardId.toString(), (Object)EBasicPermission.EDIT_ROLES);
            boolean isMine = permissionLookup.hasInstanceSpecificPermission(dashboardId.toString(), (Object)EBasicPermission.DELETE);
            boolean isFavorite = favorites.contains(dashboardId);
            return new DashboardEntryWithPermissions(dashboardId, dashboard.getName(), dashboard.group, dashboard.getOwner(), canWrite, isMine, canEditRoles, isFavorite);
        });
    }
}

