/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.clike;

import com.teamscale.index.dataflow.controlflowgraph.VariableDereferenceInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DefUseHeuristicUtils;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeSelfModificationExpressionPattern;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.IdentifierVisibilityScopeStack;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStreamParser;
import eu.cqse.check.framework.util.tokens.TokenStreamSplitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CLikeDefUseHeuristicBase
implements IDefUseHeuristic {
    public static final ETokenType ASSIGNMENT_OPERATOR = ETokenType.EQ;
    private static final EnumSet<ETokenType> MODIFICATION_OPERATOR_SET = EnumSet.of(ETokenType.PLUSEQ, new ETokenType[]{ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.URSHIFTEQ});
    private static final EnumSet<ETokenType> TWO_SIDED_ASSIGNMENT_OPERATOR_SET = EnumUtils.mergeSets(MODIFICATION_OPERATOR_SET, (Enum[])new ETokenType[]{ASSIGNMENT_OPERATOR});
    private static final TokenPattern CS_TUPLE_ASSIGNMENT = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.COMMA}).skipTo(new Object[]{ETokenType.RPAREN}).sequence(new Object[]{ASSIGNMENT_OPERATOR});
    private static final EnumSet<ETokenType> KEYWORD_TOKEN_TYPES = EnumSet.copyOf(ETokenType.KEYWORDS);
    private final IdentifierVisibilityScopeStack scopes = new IdentifierVisibilityScopeStack();
    private final Set<ETokenType> typeModifiers;
    private final Set<ETokenType> primitiveTypes;
    private final Set<ETokenType> dereferenceOperators;
    private final Set<ETokenType> notAllowedBeforeIdentifier;
    protected static final Logger LOGGER = LogManager.getLogger();

    protected CLikeDefUseHeuristicBase(Set<ETokenType> typeModifiers, Set<ETokenType> primitiveTypes, Set<ETokenType> dereferenceOperators, Set<ETokenType> notAllowedBeforeIdentifier) {
        this.typeModifiers = typeModifiers;
        this.primitiveTypes = primitiveTypes;
        this.dereferenceOperators = dereferenceOperators;
        this.notAllowedBeforeIdentifier = notAllowedBeforeIdentifier;
    }

    protected VariableReadWriteInfo parseParameterList(List<IToken> parameterListTokens, ShallowEntity methodEntity, boolean mustContainTypes) {
        VariableReadWriteInfo info = new VariableReadWriteInfo();
        TokenStreamParser parser = new TokenStreamParser(parameterListTokens, EnumSet.of(ETokenType.PREPROCESSOR_DIRECTIVE));
        while (!parser.isDone()) {
            Optional<VariableWrite> extractedParameterInfo = this.parseParameter(parser, methodEntity, mustContainTypes);
            extractedParameterInfo.ifPresent(variableWrite -> info.getDefinitions().add((VariableWrite)variableWrite));
            DefUseHeuristicUtils.skipToNextComma(parser);
        }
        return info;
    }

    private Optional<VariableWrite> parseParameter(TokenStreamParser parser, ShallowEntity methodEntity, boolean mustContainTypes) {
        Optional keyword;
        String type = this.skipType(parser, true);
        ELanguage language = parser.getTokenLanguage();
        if (language == ELanguage.JAVA) {
            this.parseAdditionalAnnotations(parser);
        }
        if ((keyword = parser.consumeOneOrZeroOf(KEYWORD_TOKEN_TYPES)).isPresent()) {
            return Optional.empty();
        }
        EnumSet<ETokenType> possibleIdentifierTokens = EnumSet.of(ETokenType.IDENTIFIER);
        IToken identifier = parser.consumeOneOrZeroOf(possibleIdentifierTokens).orElse(null);
        int startIndexOfParameter = parser.getConsumedTokenCount();
        return this.createParameter(type, identifier, mustContainTypes, () -> DefUseHeuristicUtils.createParameterListParsingErrorMessage(startIndexOfParameter, parser, type, methodEntity));
    }

    private Optional<VariableWrite> createParameter(String type, @Nullable IToken identifier, boolean mustContainTypes, Supplier<String> parameterListParsingErrorSupplier) {
        String parameterName;
        if (identifier != null) {
            parameterName = identifier.getText();
        } else {
            if (mustContainTypes) {
                LOGGER.error(parameterListParsingErrorSupplier.get());
                return Optional.empty();
            }
            parameterName = type;
        }
        if (parameterName != null && parameterName.equals("_")) {
            return Optional.empty();
        }
        this.addToScope(parameterName);
        return Optional.of(new VariableWrite(parameterName).setOther());
    }

    private void parseAdditionalAnnotations(TokenStreamParser parser) {
        this.skipAnnotations(parser);
        parser.consumeOneOrZeroOf(ETokenType.ELLIPSIS);
    }

    @Override
    public VariableReadWriteInfo parseStatement(List<IToken> tokens) {
        IToken lastToken = (IToken)CollectionUtils.getLast(tokens);
        if (lastToken != null && lastToken.getType() == ETokenType.SEMICOLON) {
            tokens = tokens.subList(0, tokens.size() - 1);
        }
        VariableReadWriteInfo info = new VariableReadWriteInfo();
        if (tokens.isEmpty()) {
            return info;
        }
        List<String> readVariables = this.parseReads(tokens);
        List<String> writtenVariables = this.parseAssignmentsAndDefinitions(tokens, info);
        for (String writtenVariable : writtenVariables) {
            readVariables.remove(writtenVariable);
        }
        info.getReads().addAll(readVariables);
        info.getDereferenceInfo().merge(this.parseDereferences(tokens));
        this.augmentWithSelfModifications(info, tokens);
        return info;
    }

    protected List<String> parseAssignmentsAndDefinitions(List<IToken> tokens, VariableReadWriteInfo info) {
        boolean isDefinitionStatement;
        int sizeOfLeadingType = this.getSizeOfLeadingType(tokens);
        boolean bl = isDefinitionStatement = sizeOfLeadingType > 0;
        if (isDefinitionStatement) {
            tokens = tokens.subList(sizeOfLeadingType, tokens.size());
        }
        if (CLikeDefUseHeuristicBase.isCsTupleAssignment(tokens)) {
            return this.parseCsTupleAssignment(tokens, info);
        }
        tokens = DefUseHeuristicUtils.cloneWithoutParenthesesAroundAssignedVar(tokens);
        ArrayList<String> writtenAndNotReadVariables = new ArrayList<String>();
        TokenStreamSplitter splitter = new TokenStreamSplitter(tokens);
        splitter.splitNested(ETokenType.LPAREN, ETokenType.RPAREN);
        splitter.splitNested(ETokenType.LBRACK, ETokenType.RBRACK);
        List tokenStreams = splitter.getTokenStreams();
        for (int i = 0; i < tokenStreams.size(); ++i) {
            List splitStream = (List)tokenStreams.get(i);
            boolean isDefinitionPart = i == 0 && isDefinitionStatement;
            List commaSeparatedParts = TokenStreamUtils.splitWithNesting((List)splitStream, (ETokenType)ETokenType.COMMA, List.of(ETokenType.LBRACE, ETokenType.LT), List.of(ETokenType.RBRACE, ETokenType.GT));
            for (List commaSeparatedPart : commaSeparatedParts) {
                boolean hasTwoSidedOperator = TokenStreamUtils.containsAny((List)commaSeparatedPart, TWO_SIDED_ASSIGNMENT_OPERATOR_SET);
                if (hasTwoSidedOperator) {
                    this.parseAssignmentChain(commaSeparatedPart, isDefinitionPart, info, writtenAndNotReadVariables);
                    continue;
                }
                if (!isDefinitionPart) continue;
                this.parseEmptyDefinition(commaSeparatedPart, info, writtenAndNotReadVariables);
            }
        }
        return writtenAndNotReadVariables;
    }

    private List<String> parseCsTupleAssignment(List<IToken> tokens, VariableReadWriteInfo info) {
        List variablesAndAssignment = TokenStreamUtils.split(tokens, (ETokenType[])new ETokenType[]{ASSIGNMENT_OPERATOR});
        if (variablesAndAssignment.size() != 2) {
            LOGGER.warn("Unexpected tuple assignment syntax in line: " + tokens.get(tokens.size() - 1).getLineNumber());
            return Collections.emptyList();
        }
        List variables = TokenStreamUtils.tokensBetween((List)((List)variablesAndAssignment.get(0)), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        List splitVariables = TokenStreamUtils.split((List)variables, (ETokenType[])new ETokenType[]{ETokenType.COMMA});
        List assignment = (List)variablesAndAssignment.get(1);
        ArrayList<String> writtenAndNotReadVariables = new ArrayList<String>();
        if (TokenStreamUtils.startsWith((List)assignment, (ETokenType[])new ETokenType[]{ETokenType.LPAREN})) {
            List assignmentValues = TokenStreamUtils.splitWithNesting(assignment.subList(1, assignment.size() - 1), (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (splitVariables.size() != assignmentValues.size()) {
                LOGGER.warn("Unexpected tuple variable assignment mismatch in line: " + tokens.get(tokens.size() - 1).getLineNumber());
                return Collections.emptyList();
            }
            for (int i = 0; i < splitVariables.size(); ++i) {
                assignment = (List)assignmentValues.get(i);
                List variable = (List)splitVariables.get(i);
                this.addTupleWriteInfo(variable, info, writtenAndNotReadVariables, assignment);
            }
        } else {
            for (List variable : splitVariables) {
                this.addTupleWriteInfo(variable, info, writtenAndNotReadVariables, assignment);
            }
        }
        return writtenAndNotReadVariables;
    }

    private void addTupleWriteInfo(List<IToken> variable, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables, List<IToken> assignment) {
        if (variable.size() > 1) {
            int sizeOfLeadingType = this.getSizeOfLeadingType(variable);
            VariableWrite write = this.parseNormalAssignment(variable.get(sizeOfLeadingType).getText(), assignment);
            writtenAndNotReadVariables.add(write.getChangedVariable());
            this.addToScope(write.getChangedVariable());
            info.getDefinitions().add(write);
        } else {
            String variableName = variable.get(0).getText();
            if (!this.isKnownVariableName(variableName)) {
                return;
            }
            VariableWrite write = this.parseNormalAssignment(variableName, assignment);
            writtenAndNotReadVariables.add(variableName);
            info.getAssignments().add(write);
        }
    }

    private static boolean isCsTupleAssignment(List<IToken> tokens) {
        return TokenStreamUtils.getLanguage(tokens) == ELanguage.CS && CS_TUPLE_ASSIGNMENT.matchAtStartOf(tokens) != null;
    }

    private void parseAssignmentChain(List<IToken> assignmentChain, boolean isDefinitionPart, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables) {
        List operatorPositions = TokenStreamUtils.findAll(assignmentChain, (ITokenMatcher)ITokenMatcher.anyOfType(TWO_SIDED_ASSIGNMENT_OPERATOR_SET));
        List assignmentParts = TokenStreamUtils.split(assignmentChain, TWO_SIDED_ASSIGNMENT_OPERATOR_SET);
        for (int k = 0; k < assignmentParts.size() - 1; ++k) {
            VariableWrite write;
            boolean isFirstAssignmentOfDefinition = isDefinitionPart && k == 0;
            List leftSide = (List)assignmentParts.get(k);
            String leftIdentifier = DefUseHeuristicUtils.extractSingleTokenText(leftSide, ETokenType.ETokenClass.IDENTIFIER);
            if (leftIdentifier == null || !isFirstAssignmentOfDefinition && !this.isKnownVariableName(leftIdentifier)) continue;
            IToken operator = assignmentChain.get((Integer)operatorPositions.get(k));
            if (operator.getType() == ASSIGNMENT_OPERATOR) {
                write = this.parseNormalAssignment(leftIdentifier, (List)assignmentParts.get(k + 1));
                writtenAndNotReadVariables.add(leftIdentifier);
            } else {
                write = new VariableWrite(leftIdentifier);
            }
            if (!isDefinitionPart && this.parseDereferences(leftSide).getDereferencedVariables().contains(leftIdentifier)) {
                write.makeWriteToDereferencedAddress();
            }
            if (isFirstAssignmentOfDefinition) {
                info.getDefinitions().add(write);
                this.addToScope(write.getChangedVariable());
                continue;
            }
            info.getAssignments().add(0, write);
        }
    }

    protected VariableWrite parseNormalAssignment(String leftIdentifier, List<IToken> rightSideOfAssignment) {
        VariableWrite write = new VariableWrite(leftIdentifier);
        while (!rightSideOfAssignment.isEmpty() && EnumSet.of(ETokenType.AND, ETokenType.MULT).contains(rightSideOfAssignment.getFirst().getType())) {
            rightSideOfAssignment = rightSideOfAssignment.subList(1, rightSideOfAssignment.size());
        }
        String rightIdentifier = DefUseHeuristicUtils.extractSingleTokenText(rightSideOfAssignment, ETokenType.ETokenClass.IDENTIFIER);
        String rightLiteral = DefUseHeuristicUtils.extractSingleTokenText(rightSideOfAssignment, ETokenType.ETokenClass.LITERAL);
        if (rightIdentifier != null && this.isKnownVariableName(rightIdentifier)) {
            write.setVariable(rightIdentifier);
        } else if (CLikeDefUseHeuristicBase.isNullValueAssignment(rightSideOfAssignment)) {
            write.setNull();
        } else if (rightLiteral != null) {
            write.setValue(rightLiteral);
        }
        if (TokenStreamUtils.startsWith(rightSideOfAssignment, (ETokenType[])new ETokenType[]{ETokenType.NEW})) {
            write.setValue("new");
        }
        return write;
    }

    private static boolean isNullValueAssignment(List<IToken> rightSideOfAssignment) {
        return rightSideOfAssignment.size() == 1 && "null".equals(rightSideOfAssignment.get(0).getText());
    }

    protected void parseEmptyDefinition(List<IToken> commaSeparatedPart, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables) {
        String definedVariable = DefUseHeuristicUtils.extractSingleTokenText(commaSeparatedPart, ETokenType.ETokenClass.IDENTIFIER);
        if (definedVariable != null) {
            info.getDefinitions().add(new VariableWrite(definedVariable).setEmpty());
            writtenAndNotReadVariables.add(definedVariable);
            this.addToScope(definedVariable);
        }
    }

    private int getSizeOfLeadingType(List<IToken> tokens) {
        TokenStreamParser parser = new TokenStreamParser(tokens);
        if (this.skipAnnotations(parser) == -1) {
            return 0;
        }
        if (this.skipType(parser, false) == null) {
            return 0;
        }
        if (!parser.isAnyOf(EnumSet.of(ETokenType.IDENTIFIER))) {
            return 0;
        }
        return parser.getConsumedTokenCount();
    }

    private void augmentWithSelfModifications(VariableReadWriteInfo info, List<IToken> tokens) {
        List matches = CLikeSelfModificationExpressionPattern.SELF_MODIFICATION_PATTERN.findAll(tokens);
        List identifiers = TokenPatternMatch.getAllStrings((List)matches, (int)0);
        for (String identifier : identifiers) {
            if (!this.isKnownVariableName(identifier)) continue;
            info.getAssignments().add(new VariableWrite(identifier));
        }
    }

    protected VariableDereferenceInfo parseDereferences(List<IToken> tokens) {
        VariableDereferenceInfo dereferenceInfo = new VariableDereferenceInfo();
        List matches = new TokenPattern().alternative(new Object[]{new TokenPattern().notPrecededBy(this.notAllowedBeforeIdentifier).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).alternative(new Object[]{this.dereferenceOperators, CLikeSelfModificationExpressionPattern.SELF_MODIFICATION_OPERATORS, MODIFICATION_OPERATOR_SET}), new TokenPattern().sequence(new Object[]{CLikeSelfModificationExpressionPattern.SELF_MODIFICATION_OPERATORS}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).notFollowedBy(this.dereferenceOperators).notFollowedBy((Object)ETokenType.LPAREN)}).findAll(tokens);
        for (TokenPatternMatch match : matches) {
            String variableName = match.groupString(0);
            if (!this.isActualVariableDereference(tokens, (Integer)match.groupIndices(0).get(0)) || !this.isKnownVariableName(variableName)) continue;
            dereferenceInfo.addDereference(match, 0);
        }
        return dereferenceInfo;
    }

    protected boolean isActualVariableDereference(List<IToken> tokens, int potentialDereferencedVariableIndex) {
        return true;
    }

    protected static boolean indexIsInOperator(List<IToken> tokens, Integer tokenIndex, String operator) {
        int currentIndex = tokenIndex;
        while (currentIndex > 0) {
            if (tokens.get(--currentIndex).getType() == ETokenType.RPAREN) {
                return false;
            }
            if (!TokenStreamTextUtils.hasSequence(tokens, (int)currentIndex, (String[])new String[]{operator, "("})) continue;
            return true;
        }
        return false;
    }

    protected abstract int skipAnnotations(TokenStreamParser var1);

    @Override
    public void openNewScope() {
        this.scopes.openNewScope();
    }

    @Override
    public void closeCurrentScope() {
        this.scopes.closeCurrentScope();
    }

    @Override
    public void addToScope(String identifier) {
        this.scopes.addIdentifierToScope(identifier);
    }

    @Override
    public boolean isKnownVariableName(String identifier) {
        return this.scopes.isKnownVariableName(identifier);
    }

    @Override
    public void addToFileScope(String identifier) {
        this.scopes.addToFileScope(identifier);
    }

    @Override
    public Set<VariableWrite> getDefinitionsInFileScope() {
        return CollectionUtils.mapToSet(this.scopes.getKnownIdentifiersOnFileScope(), VariableWrite::new);
    }

    @Override
    public Set<VariableWrite> getDefinitionsInLocalScope() {
        return Collections.emptySet();
    }

    private String skipType(TokenStreamParser parser, boolean consumeTypeModifiers) {
        this.extractTypeModifiers(parser);
        String baseType = this.skipAndReturnBaseType(parser, consumeTypeModifiers);
        if (baseType == null) {
            return null;
        }
        this.consumeTypeModifiers(parser);
        if (!CLikeDefUseHeuristicBase.hasValidArrayNotation(parser)) {
            return null;
        }
        this.consumeTypeModifiers(parser);
        return baseType;
    }

    private void extractTypeModifiers(TokenStreamParser parser) {
        do {
            if (this.skipAnnotations(parser) != -1) continue;
            LOGGER.error(SourceCodeMessageUtils.createMessage((String)"Found broken annotation in parameter list", (List)parser.getTokens(), null));
            DefUseHeuristicUtils.skipToNextComma(parser);
        } while (!this.consumeTypeModifiers(parser).isEmpty());
    }

    private static boolean hasValidArrayNotation(TokenStreamParser parser) {
        while (parser.isAnyOf(EnumSet.of(ETokenType.LBRACK))) {
            parser.consumeOneOrZeroOf(ETokenType.LBRACK);
            parser.consumeAnyOf((ITokenMatcher)ETokenType.COMMA);
            if (!parser.consumeOneOrZeroOf(ETokenType.RBRACK).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private List<IToken> consumeTypeModifiers(TokenStreamParser parser) {
        return parser.consumeAnyOf(this.typeModifiers);
    }

    private String skipAndReturnBaseType(TokenStreamParser parser, boolean consumeTypeModifiers) {
        Optional primitiveType = parser.consumeOneOrZeroOf(this.primitiveTypes);
        if (primitiveType.isPresent()) {
            return ((IToken)primitiveType.get()).getText();
        }
        return this.returnComplexTypes(parser, consumeTypeModifiers);
    }

    private String returnComplexTypes(TokenStreamParser parser, boolean consumeTypeModifiers) {
        Pair result;
        if (parser.getTokenLanguage() == ELanguage.CS && !parser.isDone() && parser.continuesWithSequence(new ETokenType[]{ETokenType.LPAREN}) && ((Boolean)(result = parser.skipBalancedParentheses()).getFirst()).booleanValue()) {
            return ((List)result.getSecond()).stream().map(IToken::getText).collect(Collectors.joining());
        }
        return this.returnGenericArguments(parser, consumeTypeModifiers);
    }

    private String returnGenericArguments(TokenStreamParser parser, boolean consumeTypeModifiers) {
        String baseType;
        do {
            if ((baseType = this.getBaseType(parser)) == null) {
                return null;
            }
            if (parser.isAnyOf(EnumSet.of(ETokenType.LT)) && !this.skipGeneric(parser)) {
                return null;
            }
            if (consumeTypeModifiers) {
                parser.consumeOneOrZeroOf(this.typeModifiers);
            } else {
                parser.consumeOneOrZeroOf(ETokenType.QUESTION);
            }
            ETokenType currentType = parser.currentType();
            if (currentType == null || currentType.getTokenClass() != ETokenType.ETokenClass.OPERATOR) continue;
            return null;
        } while (parser.consumeOneOrZeroOf(EnumSet.of(ETokenType.DOT)).isPresent());
        return baseType;
    }

    private @Nullable String getBaseType(TokenStreamParser parser) {
        List baseTypeParts;
        while (true) {
            baseTypeParts = parser.consumeAlternating(EnumSet.of(ETokenType.IDENTIFIER), EnumSet.of(ETokenType.DOT));
            while (this.skipAnnotations(parser) > 0 && Objects.requireNonNull((IToken)CollectionUtils.getLast((List)baseTypeParts)).getType() == ETokenType.DOT) {
                baseTypeParts.addAll(parser.consumeAlternating(EnumSet.of(ETokenType.IDENTIFIER), EnumSet.of(ETokenType.DOT)));
            }
            if (baseTypeParts.isEmpty() || Objects.requireNonNull((IToken)CollectionUtils.getLast((List)baseTypeParts)).getType() == ETokenType.DOT) {
                return null;
            }
            if (!parser.isAnyOf(EnumSet.of(ETokenType.COLON))) break;
            parser.consumeAnyOf((ITokenMatcher)ETokenType.COLON);
        }
        String baseType = StringUtils.concat((Iterable)baseTypeParts);
        return baseType;
    }

    private boolean skipGeneric(TokenStreamParser parser) {
        return (Boolean)parser.skipBalancedAngleBrackets().getFirst();
    }

    protected List<String> parseReads(List<IToken> tokens) {
        ArrayList<String> readIdentifiers = new ArrayList<String>();
        List matches = new TokenPattern().notPrecededBy(this.notAllowedBeforeIdentifier).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).notFollowedBy((Object)ETokenType.LPAREN).findAll(tokens);
        List identifiers = TokenPatternMatch.getAllStrings((List)matches, (int)0);
        for (String identifier : identifiers) {
            if (!this.isKnownVariableName(identifier)) continue;
            readIdentifiers.add(identifier);
        }
        return readIdentifiers;
    }
}

