/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallInputValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraph;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSink;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSourceBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MethodTaintGraphWithPaths
extends MethodTaintGraph {
    private static final long serialVersionUID = 1L;
    private final Map<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>> paths;

    public MethodTaintGraphWithPaths(String methodId, HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> taintGraph, Map<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>> paths, long commitTimestamp) {
        super(methodId, taintGraph, commitTimestamp);
        this.paths = new HashMap<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>>(paths);
    }

    public MethodTaintGraphWithPaths(String methodId, HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> taintGraph, long commitTimestamp) {
        super(methodId, taintGraph, commitTimestamp);
        this.paths = new HashMap<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>>();
    }

    public Set<List<TaintGraphReferenceBase>> getPathsFromTo(TaintGraphReferenceBase from, TaintGraphReferenceBase to) {
        return this.paths.getOrDefault(new Pair((Object)from, (Object)to), Collections.emptySet());
    }

    public Boolean containsPath(TaintGraphReferenceBase from, TaintGraphReferenceBase to) {
        return this.paths.containsKey(new Pair((Object)from, (Object)to));
    }

    public Set<List<TaintGraphReferenceBase>> getSinkPathsDirectlyInfluencedBy(MethodCallInputValueReference callInputReference) {
        Set allSinks = this.getInfluenceGraph().keySet().stream().filter(key -> key.getType() == TaintGraphReferenceBase.EReferenceType.SINK).map(key -> (TaintGraphSink)key).collect(Collectors.toSet());
        HashSet<List<TaintGraphReferenceBase>> influencedSinkPaths = new HashSet<List<TaintGraphReferenceBase>>();
        for (TaintGraphSink sink : allSinks) {
            ArrayList<TaintGraphReferenceBase> matchingInfluences = new ArrayList<TaintGraphReferenceBase>();
            for (TaintGraphReferenceBase influence : this.getInfluenceGraph().get(sink)) {
                if (!MethodTaintGraphWithPaths.callInputMatchesLocalReference(callInputReference, influence)) continue;
                matchingInfluences.add(influence);
            }
            for (TaintGraphReferenceBase influence : matchingInfluences) {
                if (this.containsPath(influence, sink).booleanValue()) {
                    influencedSinkPaths.addAll(this.getPathsFromTo(influence, sink));
                    continue;
                }
                influencedSinkPaths.add(Collections.singletonList(sink));
            }
        }
        return influencedSinkPaths;
    }

    public Map<Pair<TaintGraphSourceBase, TaintGraphSink>, Set<List<TaintGraphReferenceBase>>> getTaintPaths() {
        HashMap<Pair<TaintGraphSourceBase, TaintGraphSink>, Set<List<TaintGraphReferenceBase>>> taintPaths = new HashMap<Pair<TaintGraphSourceBase, TaintGraphSink>, Set<List<TaintGraphReferenceBase>>>();
        for (Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> key : this.paths.keySet()) {
            if (!TaintGraphReferenceBase.EReferenceType.SOURCE_REFERENCE_TYPES.contains((Object)((TaintGraphReferenceBase)key.getFirst()).getType()) || ((TaintGraphReferenceBase)key.getSecond()).getType() != TaintGraphReferenceBase.EReferenceType.SINK) continue;
            Pair castKey = new Pair((Object)((TaintGraphSourceBase)key.getFirst()), (Object)((TaintGraphSink)key.getSecond()));
            taintPaths.put((Pair<TaintGraphSourceBase, TaintGraphSink>)castKey, this.paths.get(key));
        }
        return taintPaths;
    }

    public Set<? extends String> getUniformPathsOfSinks() {
        return this.paths.keySet().stream().filter(fromTo -> ((TaintGraphReferenceBase)fromTo.getSecond()).getType() == TaintGraphReferenceBase.EReferenceType.SINK).map(fromTo -> ((TaintGraphReferenceBase)fromTo.getSecond()).getLocation().getUniformPath()).collect(Collectors.toSet());
    }
}

