/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.external.ExternalStorageBackendResolvedCommitAndRevision;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisSessionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final CommitDescriptor commit;
    private final String username;
    private final String message;
    private final String partition;
    private boolean open = true;
    private final boolean moveUploadToLastCommit;
    private final long uploadTimestamp;
    private final @Nullable String revision;
    private @Nullable String repository;
    private final @Nullable ExternalStorageBackend targetStorage;
    private long maxReportSize = 0L;

    public ExternalAnalysisSessionInfo(String sessionId, @Nullable ExternalStorageBackend targetStorage, ExternalStorageBackendResolvedCommitAndRevision commitAndRevision, String username, String message, String partition, boolean moveUploadToLastCommit, long uploadTimestamp) throws StorageException {
        this.sessionId = sessionId;
        this.targetStorage = targetStorage;
        this.repository = commitAndRevision.repository();
        this.revision = commitAndRevision.revision();
        this.commit = commitAndRevision.commit();
        this.username = username;
        this.message = message;
        ExternalAnalysisPartitionIndex.validatePartitionName(partition);
        this.partition = partition;
        this.moveUploadToLastCommit = moveUploadToLastCommit;
        this.uploadTimestamp = uploadTimestamp;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public @Nullable ExternalStorageBackend getTargetStorage() {
        return this.targetStorage;
    }

    public @Nullable String getRepository() {
        return this.repository;
    }

    public @Nullable String getRevision() {
        return this.revision;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public String getUsername() {
        return this.username;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageWithPartition() {
        return this.message + " (" + this.partition + ")";
    }

    public String getPartition() {
        return this.partition;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setCommitted() {
        this.open = false;
    }

    public boolean shouldMoveUploadToLastCommit() {
        return this.moveUploadToLastCommit;
    }

    public long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public long getMaxReportSize() {
        return this.maxReportSize;
    }

    public String toString() {
        return "ExternalAnalysisSessionInfo [sessionId=" + this.sessionId + ", commit=" + String.valueOf(this.commit) + ", username=" + this.username + ", message=" + this.message + ", partition=" + this.partition + "]";
    }

    public void updateMaxReportSize(ExternalAnalysisImportInfos value) {
        for (ExternalAnalysisImportInfoReport reportInfo : value.filterByType(ExternalAnalysisImportInfoReport.class)) {
            this.maxReportSize = Math.max(this.maxReportSize, (long)reportInfo.getData().length());
        }
    }

    public void setRepository(@Nullable String repositoryId) {
        this.repository = repositoryId;
    }
}

