/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.issues.gitlab.client.model.GitLabIssue;
import com.teamscale.index.issues.gitlab.client.model.GitLabIssueStateEvent;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.TestOnly;
import retrofit2.Call;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface IGitLabIssueApi
extends IRetrofitApi {
    public static final String REST_API_BASE_PATH = "api/v4/";
    public static final String PROJECT_PARAMETER_NAME = "projectIdOrPath";
    public static final String PROJECT_ENDPOINT = "api/v4/projects/{projectIdOrPath}";
    public static final String LIST_PROJECT_ISSUES_ENDPOINT = "api/v4/projects/{projectIdOrPath}/issues";
    public static final String ISSUE_ID_PARAMETER_NAME = "issueId";
    public static final String ISSUE_ENDPOINT = "api/v4/projects/{projectIdOrPath}/issues/{issueId}";
    public static final String LIST_ISSUE_STATE_EVENTS_ENDPOINT = "api/v4/projects/{projectIdOrPath}/issues/{issueId}/resource_state_events";

    @GET(value="api/v4/projects/{projectIdOrPath}/issues?order_by=updated_at&sort=asc&state=all&with_labels_details=false")
    public Call<List<GitLabIssue>> getProjectIssues(@Path(value="projectIdOrPath") String var1, @Query(value="labels") Collection<String> var2, @Query(value="updated_after") @Nullable Instant var3);

    @POST(value="api/v4/projects/{projectIdOrPath}/issues")
    @TestOnly
    public Void createProjectIssue(@Path(value="projectIdOrPath") String var1, @Query(value="title") String var2) throws ServiceCallException;

    @DELETE(value="api/v4/projects/{projectIdOrPath}/issues/{issueId}")
    @TestOnly
    public Void deleteProjectIssue(@Path(value="projectIdOrPath") String var1, @Path(value="issueId") Integer var2) throws ServiceCallException;

    @GET
    public Call<List<GitLabIssue>> getNextProjectIssues(@Url String var1);

    @GET(value="api/v4/projects/{projectIdOrPath}/issues/{issueId}/resource_state_events")
    public Call<List<GitLabIssueStateEvent>> getIssueStateEvents(@Path(value="projectIdOrPath") String var1, @Path(value="issueId") long var2);

    @GET
    public Call<List<GitLabIssueStateEvent>> getNextIssueStateEvents(@Url String var1);
}

