/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.client.JiraInstanceAwareClient;
import com.teamscale.index.issues.model.ExternalToolIssueCustomFieldValidationResultError;
import com.teamscale.index.issues.model.ExternalToolIssueCustomFieldValidationResultSuccess;
import com.teamscale.index.issues.model.IExternalToolIssueCustomFieldValidationResult;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.ParseException;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class JiraConnectorUtils {
    public static void validateAccountDetails(JiraClient jiraClient, List<String> projects) throws ConnectorValidationException {
        try {
            JiraInstanceAwareClient jiraInstanceAwareClient = jiraClient.toInstanceAwareClient(jiraClient.getInstanceType());
            Map<String, String> jiraProjectNamesByJiraKey = jiraInstanceAwareClient.getProjectNamesByKey();
            JiraConnectorUtils.ensureJiraProjectIsNotReferencedTwice(projects, jiraProjectNamesByJiraKey);
            if (jiraProjectNamesByJiraKey.isEmpty()) {
                throw new ConnectorValidationException("Jira returned an empty project list (\"[]\"). This can happen in the following cases: the provided token does not belong to the provided username (e.g. using display name instead of username), or the user does not have sufficient permissions (required permission is 'Browse projects' or 'Administer projects').");
            }
            HashSet missingProjects = CollectionUtils.differenceSet(projects, (Collection[])new Collection[]{jiraProjectNamesByJiraKey.keySet(), jiraProjectNamesByJiraKey.values()});
            if (!missingProjects.isEmpty()) {
                throw new ConnectorValidationException("Some projects couldn't be found in Jira: " + StringUtils.concat((Iterable)missingProjects, (String)", "));
            }
        }
        catch (ServiceCallException e) {
            if (StringUtils.getFirstPart((String)e.getMessage(), (char)'\n').matches("Request to '.+' was not successful: 404 .*")) {
                throw new ConnectorValidationException("No Jira server found or Jira version too old. We need the /api/2 endpoints introduced with Jira 5.0! Specifically, we tried to access rest/api/2/project", (Throwable)e);
            }
            throw new ConnectorValidationException((Throwable)e);
        }
        catch (BugTrackerException | ParseException e) {
            throw new ConnectorValidationException(e);
        }
    }

    @VisibleForTesting
    static void ensureJiraProjectIsNotReferencedTwice(Collection<String> projects, Map<String, String> jiraProjectNamesByKey) throws ConnectorValidationException {
        HashSet<String> userSpecifiedProjects = new HashSet<String>(projects);
        Set projectSpecifiedMoreThanOnce = userSpecifiedProjects.stream().filter(project -> jiraProjectNamesByKey.containsKey(project) && !project.equals(jiraProjectNamesByKey.get(project)) && userSpecifiedProjects.contains(jiraProjectNamesByKey.get(project))).collect(Collectors.toSet());
        if (!projectSpecifiedMoreThanOnce.isEmpty()) {
            throw new ConnectorValidationException("The following projects were specified both by Jira project key *and* by name. Please remove one of those entries : " + StringUtils.concat(projectSpecifiedMoreThanOnce, (String)", "));
        }
    }

    public static boolean shouldHideResolveFindingsInBadges(ProjectStorageSystem projectStorageSystem, Logger logger) {
        try {
            MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
            ProjectConfiguration projectConfig = (ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class);
            if (projectConfig == null) {
                return false;
            }
            UnmodifiableList connectors = projectConfig.getConnectors();
            HashSet issueTrackers = new HashSet(CollectionUtils.map((Object[])EIssueTracker.values(), EIssueTracker::getReadableName));
            for (ConnectorConfiguration connector : connectors) {
                if (!issueTrackers.contains(connector.getType())) continue;
                return Boolean.parseBoolean(connector.getOptionValue("Hide resolved findings in issue badges"));
            }
        }
        catch (StorageException e) {
            logger.error("Error reading the 'excludeResolvedFindings' option value", (Throwable)e);
        }
        return false;
    }

    public static List<IExternalToolIssueCustomFieldValidationResult> validateCustomJiraFields(@NonNull PairList<String, Boolean> requestedCustomFields, @NonNull JiraClient jiraClient) throws BugTrackerException {
        if (requestedCustomFields.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        try {
            ArrayList<IExternalToolIssueCustomFieldValidationResult> validationResults = new ArrayList<IExternalToolIssueCustomFieldValidationResult>(requestedCustomFields.size());
            Map<String, List<String>> customFieldMapping = jiraClient.getCustomFieldMappings();
            for (Pair pair : requestedCustomFields) {
                validationResults.addAll(JiraConnectorUtils.validateCustomJiraField((Pair<String, Boolean>)pair, customFieldMapping));
            }
            return validationResults;
        }
        catch (ServiceCallException | BugTrackerException e) {
            throw new BugTrackerException("Failed to retrieve custom fields.", e);
        }
    }

    private static List<IExternalToolIssueCustomFieldValidationResult> validateCustomJiraField(Pair<String, Boolean> entry, Map<String, List<String>> customFieldMapping) throws BugTrackerException, ServiceCallException {
        String customFieldName = (String)entry.getFirst();
        if (customFieldName.equals("projectKey")) {
            return Collections.singletonList(new ExternalToolIssueCustomFieldValidationResultError("It is not possible to select 'projectKey' as a custom field, because it is reserved for the Jira project."));
        }
        List<String> customFieldIds = customFieldMapping.get(customFieldName);
        if (customFieldIds == null) {
            return Collections.singletonList(new ExternalToolIssueCustomFieldValidationResultError("Custom field does not exist: " + customFieldName));
        }
        if (customFieldIds.isEmpty()) {
            return Collections.singletonList(new ExternalToolIssueCustomFieldValidationResultError("Custom field does not have any IDs: " + customFieldName));
        }
        return CollectionUtils.map(customFieldIds, customFieldId -> new ExternalToolIssueCustomFieldValidationResultSuccess(new ExternalToolIssueCustomField(customFieldId, customFieldName, ((Boolean)entry.getSecond()).booleanValue(), null)));
    }

    public static boolean hasValidationErrors(List<IExternalToolIssueCustomFieldValidationResult> validationResults) {
        return CollectionUtils.anyMatch(validationResults, validationResult -> !validationResult.isSuccessful());
    }

    private JiraConnectorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

