/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.finding;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.index.migration.finding.ConfigurationOptionMigrationBase;

public class ConfigurationOptionReplacement
extends ConfigurationOptionMigrationBase {
    public final boolean removeOldOption;

    public ConfigurationOptionReplacement(String oldOptionNameOrCheckId, String newOptionNameOrCheckId, String analysisGroup) {
        this(oldOptionNameOrCheckId, analysisGroup, newOptionNameOrCheckId, analysisGroup);
    }

    public ConfigurationOptionReplacement(String oldOptionNameOrCheckId, String oldAnalysisGroup, String newOptionNameOrCheckId, String newAnalysisGroup) {
        this(oldOptionNameOrCheckId, oldAnalysisGroup, newOptionNameOrCheckId, newAnalysisGroup, true);
    }

    public ConfigurationOptionReplacement(String oldOptionNameOrCheckId, String oldAnalysisGroup, String newOptionNameOrCheckId, String newAnalysisGroup, boolean removeOldOption) {
        super(oldOptionNameOrCheckId, oldAnalysisGroup, newOptionNameOrCheckId, newAnalysisGroup);
        this.removeOldOption = removeOldOption;
    }

    public ConfigurationOptionReplacement(String oldOptionName, String oldAnalysisGroup, String newOptionName, String newAnalysisGroup, ConfigurationOptionMigrationBase.EConflictResolutionStrategy conflictResolutionStrategy) {
        super(oldOptionName, oldAnalysisGroup, newOptionName, newAnalysisGroup, conflictResolutionStrategy);
        this.removeOldOption = true;
    }

    @Override
    protected void doMigrateJson(ObjectNode analysisProfile) {
        if (this.removeOldOption) {
            this.removeOption(this.oldOptionName);
        }
        this.createNewOptionWithEnablement(analysisProfile);
    }

    public String toString() {
        Object string = "[Replace]: ";
        if (this.removeOldOption) {
            string = (String)string + " Remove '" + this.oldOptionName + "'; ";
        }
        return (String)string + "New option '" + this.newOptionName + "' with value '" + this.optionValue + "'";
    }
}

