/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v123_compile_commands;

import com.teamscale.index.migration.v123_compile_commands.V123TeamscaleIssue;
import com.teamscale.index.migration.v123_compile_commands.V123TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class V123SpecItem
extends V123TeamscaleIssue {
    private static final long serialVersionUID = 1L;
    private final List<String> additionalAssignees;
    private final List<String> additionalFieldTypes;
    private final List<V123TeamscaleIssue.V123TeamscaleIssueId> additionalParents;
    private final List<String> linkRoles;
    private final List<List<V123TeamscaleIssue.V123TeamscaleIssueId>> linkedSpecItems;
    private @Nullable V123TeamscaleIssueTypeInfo typeInfo;

    private V123SpecItem(V123TeamscaleIssue.V123TeamscaleIssueId id, long created, List<String> additionalFieldNames, List<String> additionalFieldValues, List<String> additionalFieldTypes, String url, String firstParent, List<String> additionalParents) {
        super(id, null, null, null, null, created, 0L, null, false, url, additionalFieldNames, additionalFieldValues, firstParent);
        this.additionalAssignees = new ArrayList<String>();
        this.additionalFieldTypes = additionalFieldTypes;
        this.linkRoles = new ArrayList<String>();
        this.linkedSpecItems = new ArrayList<List<V123TeamscaleIssue.V123TeamscaleIssueId>>();
        this.additionalParents = additionalParents.stream().map(String::trim).map(id::withExternalId).collect(Collectors.toList());
    }

    public V123SpecItem(V123TeamscaleIssue.V123TeamscaleIssueId id, String subject, String assignee, String author, String description, long created, long updated, String status, boolean closed, String url, List<String> additionalFieldNames, List<String> additionalFieldValues, V123TeamscaleIssue.V123TeamscaleIssueId parentId, List<String> additionalAssignees, List<String> additionalFieldTypes, List<V123TeamscaleIssue.V123TeamscaleIssueId> additionalParents, List<String> linkRoles, List<List<V123TeamscaleIssue.V123TeamscaleIssueId>> linkedSpecItems, String type, String typeAbbreviation) {
        super(id, subject, assignee, author, description, created, updated, status, closed, url, additionalFieldNames, additionalFieldValues, parentId);
        this.additionalAssignees = new ArrayList<String>(additionalAssignees);
        this.additionalFieldTypes = additionalFieldTypes;
        CCSMAssert.isTrue((linkRoles.size() == linkedSpecItems.size() ? 1 : 0) != 0, (String)"Lists for link roles and linked requirements must have same length");
        this.linkRoles = new ArrayList<String>(linkRoles);
        this.linkedSpecItems = new ArrayList<List<V123TeamscaleIssue.V123TeamscaleIssueId>>(linkedSpecItems);
        this.additionalParents = additionalParents;
        CCSMAssert.isNotNull((Object)id, (String)"A requirement must have a non-empty ID.");
        this.typeInfo = new V123TeamscaleIssueTypeInfo(type, typeAbbreviation);
    }

    public V123SpecItem(V123SpecItem specItem) {
        super(specItem);
        this.additionalAssignees = new ArrayList<String>(specItem.additionalAssignees);
        this.additionalFieldTypes = new ArrayList<String>(specItem.additionalFieldTypes);
        this.additionalParents = new ArrayList<V123TeamscaleIssue.V123TeamscaleIssueId>(specItem.additionalParents);
        this.linkRoles = new ArrayList<String>(specItem.linkRoles);
        this.linkedSpecItems = new ArrayList<List<V123TeamscaleIssue.V123TeamscaleIssueId>>(specItem.linkedSpecItems);
        this.typeInfo = specItem.typeInfo;
    }

    public V123SpecItem(V123TeamscaleIssue issue, List<String> additionalAssignees, List<String> additionalParents, List<String> linkRoles, List<List<String>> linkedSpecItems, String type, String typeAbbreviation) {
        super(issue);
        this.additionalAssignees = new ArrayList<String>(additionalAssignees);
        this.additionalFieldTypes = new ArrayList<String>();
        this.linkRoles = new ArrayList<String>(linkRoles);
        this.linkedSpecItems = linkedSpecItems.stream().map(specItemIds -> specItemIds.stream().map(issue.getId()::withExternalId).collect(Collectors.toList())).collect(Collectors.toList());
        this.additionalParents = additionalParents.stream().map(String::trim).map(issue.getId()::withExternalId).collect(Collectors.toList());
        this.typeInfo = new V123TeamscaleIssueTypeInfo(type, typeAbbreviation);
    }

    public V123SpecItem(V123TeamscaleIssue issue, V123TeamscaleIssueTypeInfo typeInfo) {
        super(issue);
        this.additionalAssignees = Collections.emptyList();
        this.additionalFieldTypes = Collections.emptyList();
        this.linkRoles = Collections.emptyList();
        this.linkedSpecItems = Collections.emptyList();
        this.additionalParents = Collections.emptyList();
        this.typeInfo = typeInfo;
    }
}

