/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v181_view_user_statistics_permission;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.v181_view_user_statistics_permission.V181EGlobalPermission;
import com.teamscale.index.migration.v181_view_user_statistics_permission.V181GlobalRole;
import com.teamscale.index.migration.v181_view_user_statistics_permission.V181RoleBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion181ViewUserStatisticsPermission
implements IPointwiseStorageMigrator {
    private final ClassNameMigrator permissionClassNameMigrator = new ClassNameMigrator();

    public MigrateVersion181ViewUserStatisticsPermission() {
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EGlobalPermission", V181EGlobalPermission.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.RoleBase", V181RoleBase.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.GlobalRole", V181GlobalRole.class);
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V181;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public String getStoreName() {
        return "permissions";
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        V181GlobalRole globalRole;
        String globalRoleKey = "GLOBAL_ROLE#";
        String stringKey = StringUtils.bytesToString((byte[])key);
        if (stringKey.startsWith(globalRoleKey) && (globalRole = (V181GlobalRole)this.permissionClassNameMigrator.deserialize(LZ4Utils.decompress((byte[])value))).getPermissions().contains((Object)V181EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES)) {
            globalRole.addPermission(V181EGlobalPermission.VIEW_USER_STATISTICS);
            return PairList.from((Object)key, (Object)LZ4Utils.compress((byte[])this.permissionClassNameMigrator.serialize(globalRole)));
        }
        return PairList.from((Object)key, (Object)value);
    }
}

