/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.naming.CNamingConventionAnalyzer;
import com.teamscale.index.naming.CppNamingConventionAnalyzer;
import com.teamscale.index.naming.CsNamingConventionAnalyzer;
import com.teamscale.index.naming.GosuNamingConventionAnalyzer;
import com.teamscale.index.naming.JavaNamingConventionAnalyzer;
import com.teamscale.index.naming.JavaScriptNamingConventionAnalyzer;
import com.teamscale.index.naming.MatlabNamingConventionAnalyzer;
import com.teamscale.index.naming.NamingConventionAnalyzer;
import com.teamscale.index.naming.OScriptNamingConventionAnalyzer;
import com.teamscale.index.naming.PhpNamingConventionAnalyzer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class NamingConventionSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    @StepParameterObject(namePrefix="oscript-")
    private final NamingConventionAnalyzer oscriptAnalyzer = new OScriptNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="gosu-")
    private final NamingConventionAnalyzer gosuAnalyzer = new GosuNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="java-")
    private final NamingConventionAnalyzer javaAnalyzer = new JavaNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="cpp-")
    private final NamingConventionAnalyzer cppAnalyzer = new CppNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="c-")
    private final NamingConventionAnalyzer cAnalyzer = new CNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="cs-")
    private final NamingConventionAnalyzer csAnalyzer = new CsNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="javascript-")
    private final NamingConventionAnalyzer javascriptAnalyzer = new JavaScriptNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="matlab-")
    private final NamingConventionAnalyzer matlabAnalyzer = new MatlabNamingConventionAnalyzer();
    @StepParameterObject(namePrefix="php-")
    private final NamingConventionAnalyzer phpAnalyzer = new PhpNamingConventionAnalyzer();
    private final List<NamingConventionAnalyzer> allAnalyzers = List.of(this.oscriptAnalyzer, this.gosuAnalyzer, this.javaAnalyzer, this.cppAnalyzer, this.cAnalyzer, this.csAnalyzer, this.javascriptAnalyzer, this.matlabAnalyzer, this.phpAnalyzer);

    public void execute() throws StorageException {
        List scope = this.contentDelta.getAddedOrChangedKeysAsStrings();
        CodeScopeAware findings = CodeScopeAware.empty();
        for (NamingConventionAnalyzer namingConventionAnalyzer : this.allAnalyzers) {
            findings.merge(this.analyzeNamingConventions(scope, namingConventionAnalyzer), (findings1, findings2) -> {
                ListMap result = new ListMap(findings1);
                result.addAll((CollectionMap)findings2);
                return result;
            });
        }
        this.synchronizeFindingsForTokenElementIndexDelta((CodeScopeAware<ListMap<String, IndexFinding>>)findings, "naming-conventions");
    }

    private CodeScopeAware<ListMap<String, IndexFinding>> analyzeNamingConventions(List<String> uniformPaths, NamingConventionAnalyzer analyzer) throws StorageException {
        ELanguage language = analyzer.getLanguage();
        uniformPaths = CollectionUtils.filter(uniformPaths, path -> ELanguage.getAllLanguagesForPath((String)path).contains(language));
        List elements = this.getContentIndexCache().getTokenElementInfos(UniformPathCompatibilityUtil.convertCollection((Collection)uniformPaths));
        elements = CollectionUtils.filter(elements, tokenElementInfo -> tokenElementInfo.getLanguage() == language);
        analyzer.performAnalysis(elements);
        return analyzer.getFindings();
    }

    public static String getPatternParameterName(ELanguage language) {
        return NamingConventionSynchronizer.getParameterName(language, "patterns");
    }

    public static String getEnablementParameterName(ELanguage language) {
        return NamingConventionSynchronizer.getParameterName(language, "enabled");
    }

    private static String getParameterName(ELanguage language, String parameter) {
        return language.name().toLowerCase() + "-" + parameter;
    }
}

