/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.index.quality_report.QualityArtifactParameters;
import com.teamscale.index.quality_report.SlideCallouts;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.AssessmentTrendChartSlide;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.FindingDetailSlide;
import com.teamscale.index.quality_report.slides.ImageSlide;
import com.teamscale.index.quality_report.slides.MarkdownSlide;
import com.teamscale.index.quality_report.slides.MetricBarChartSlide;
import com.teamscale.index.quality_report.slides.MetricTreemapSlide;
import com.teamscale.index.quality_report.slides.MetricTrendChartSlide;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SectionTitleSlide;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide;
import com.teamscale.index.quality_report.slides.TaskDetailSlide;
import com.teamscale.index.quality_report.slides.TasksSlide;
import com.teamscale.index.quality_report.slides.TestGapTreemapSlide;
import com.teamscale.index.quality_report.slides.TitleSlide;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="typeId")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TitleSlide.class, name="TITLE"), @JsonSubTypes.Type(value=TasksSlide.class, name="TASKS"), @JsonSubTypes.Type(value=SystemQualityOverviewSlide.class, name="SYSTEM_QUALITY_OVERVIEW"), @JsonSubTypes.Type(value=FindingDetailSlide.class, name="FINDING_DETAIL"), @JsonSubTypes.Type(value=ImageSlide.class, name="IMAGE"), @JsonSubTypes.Type(value=TestGapTreemapSlide.class, name="TEST_GAP_TREEMAP"), @JsonSubTypes.Type(value=SectionTitleSlide.class, name="SECTION_TITLE"), @JsonSubTypes.Type(value=MarkdownSlide.class, name="MARKDOWN"), @JsonSubTypes.Type(value=TaskDetailSlide.class, name="TASK_DETAIL"), @JsonSubTypes.Type(value=MetricBarChartSlide.class, name="METRIC_ASSESSMENT"), @JsonSubTypes.Type(value=MetricTrendChartSlide.class, name="METRIC_TREND"), @JsonSubTypes.Type(value=AssessmentTrendChartSlide.class, name="ASSESSMENT_TREND"), @JsonSubTypes.Type(value=MetricTreemapSlide.class, name="METRIC_TREEMAP")})
@IndexValueClass(containedInBackup=true)
public abstract class ReportSlideBase<T extends SlideParametersBase, S extends SlideRenderDataBase>
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="typeId")
    private String typeId = this.getSlideType().name();
    @JsonProperty(value="slideParameters")
    private T slideParameters;
    @JsonProperty(value="callouts")
    private @Nullable SlideCallouts callouts;
    @JsonProperty(value="id")
    private String id;

    public abstract EReportSlide getSlideType();

    public String getTypeId() {
        return this.typeId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public T getSlideParameters() {
        return this.slideParameters;
    }

    public void setSlideParameters(T slideParameters) {
        this.slideParameters = slideParameters;
    }

    public void setCallouts(SlideCallouts callouts) {
        this.callouts = callouts;
    }

    public void reset(QualityArtifactParameters report, boolean baseSettingsChanged) {
        if (baseSettingsChanged) {
            this.setIsDraft(true);
            this.resetUserOverwrites();
        }
    }

    protected void resetUserOverwrites() {
    }

    public void setIsDraft(boolean isDraft) {
        ((SlideParametersBase)this.slideParameters).setSlideIsDraft(isDraft);
    }

    public @Nullable String getId() {
        return this.id;
    }

    public void updateDefaultProjectBranchPath(ProjectBranchPath oldDefaultSettings, ProjectBranchPath newDefaultSettings) {
        if (oldDefaultSettings.equals(newDefaultSettings)) {
            return;
        }
        T slideParameters = this.getSlideParameters();
        for (EReportSlide.SlideParameterDescriptor descriptor : this.getSlideType().parameterDescriptors) {
            if (descriptor.type() != ESlideOptionType.PROJECT_BRANCH_PATH && descriptor.type() != ESlideOptionType.PROJECT) continue;
            Field parameterField = ReflectionUtils.getField(slideParameters.getClass(), (String)descriptor.name());
            parameterField.setAccessible(true);
            try {
                ProjectBranchPath oldSetting = (ProjectBranchPath)parameterField.get(slideParameters);
                if (!oldDefaultSettings.getProjectId().equals((Object)oldSetting.getProjectId())) continue;
                parameterField.set(slideParameters, newDefaultSettings);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Error trying to apply new default project for parameter " + String.valueOf((Object)descriptor.type()), (Throwable)e);
            }
        }
    }
}

