/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.mock_connector;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestSynchronizer;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestVotingTrigger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.PairList;

@ConnectorDescriptor(enabledByFeatureToggle=EFeatureToggle.ENABLE_TEST_MODE)
public class ArtificialMergeRequestRepositoryConnectorDescriptor
extends GitRepositoryManagementConnectorDescriptorBase {
    public static final String BRANCHES_FOR_MERGE_REQUESTS_PARAMETER = "merge-request-branches";
    public static final String BRANCHES_FOR_MERGE_REQUESTS_OPTION = "Branches for artificial merge requests";
    @ConfigExposed(name="Branches for artificial merge requests", description="A list of branches, for which artificial merge requests will be created. The format is <sourceBranch> -> <targetBranch> with one tuple per line.", multilineText=true, visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public PairList<String, String> branchesForMergeRequests = new PairList();
    @ConfigExposed(name="Badges for Metrics", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Metrics which should be tracked in merge requests via badges.")
    protected MetricBadgesConfiguration metricThresholdBadges = new MetricBadgesConfiguration();
    @ConfigExposed(name="Badges for Metric Groups", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Metrics which should be included in a summarized badge for their group in merge requests.")
    protected MetricBadgesConfiguration metricThresholdGroupBadges = new MetricBadgesConfiguration();

    public ArtificialMergeRequestRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.ARTIFICIAL_MERGE_REQUEST);
        this.branchingEnabled = true;
        this.findingsIntegrationEnabled = false;
        this.testGapIntegrationEnabled = false;
        this.commitAlertsIntegrationEnabled = false;
        this.hideOption("Enable Findings integration for merge requests");
        this.hideOption("Enable Commit Alerts for merge requests");
        this.hideOption("Aggregate Findings in Single Comment");
        this.autoExpose();
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        if (!this.branchingEnabled) {
            throw new ConnectorValidationException("Branching must be enabled for this connector");
        }
        if (this.findingsIntegrationEnabled) {
            throw new ConnectorValidationException("Findings integration is not supported for this connector");
        }
        if (this.commitAlertsIntegrationEnabled) {
            throw new ConnectorValidationException("Commit alerts integration is not supported for this connector");
        }
        if (this.branchesForMergeRequests.isEmpty()) {
            throw new ConnectorValidationException("At least one branch for artificial merge requests is needed");
        }
    }

    @Override
    public String getPathSuffix() {
        return this.repositoryName;
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return ArtificialMergeRequestVotingTrigger.class;
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return ArtificialMergeRequestSynchronizer.class;
    }

    @Override
    protected void setPullRequestSynchronizerParameters(TriggerBuilder trigger) throws ProjectConfigurationException {
        super.setPullRequestSynchronizerParameters(trigger);
        trigger.setTriggerParameter(BRANCHES_FOR_MERGE_REQUESTS_PARAMETER, ITriggerParameter.of(this.branchesForMergeRequests));
        trigger.setTriggerParameter("Repository name", this.repositoryName);
        trigger.setTriggerParameter("repository-path", this.getRepositoryUri().toString());
        trigger.setTriggerParameter("default-branch-name", this.defaultBranchName);
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return "https://cqse.eu/link?c={commitId}";
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() {
        return "https://cqse.eu/link?c={commitId}&m={mergeRequestId}";
    }

    @Override
    protected void validateExcludeBranches() {
    }
}

