/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history;

import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Index(name="elementhistory", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class ElementHistoryIndex
implements IProjectIndex {
    private final ValueIndex<ElementHistoryEntry> delegate;
    public static final String INDEX_NAME = "elementhistory";

    public ElementHistoryIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void insertAndMergeHistoryEntries(PairList<String, ElementHistoryEntry> pathToHistoryEntry) throws StorageException {
        this.delegate.setOrMergeValues(pathToHistoryEntry, (elementHistoryEntry, elementHistoryEntry2) -> {
            if (elementHistoryEntry2.getChangeType() == EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD && elementHistoryEntry.getCommit().equals((Object)elementHistoryEntry2.getCommit())) {
                return elementHistoryEntry;
            }
            return elementHistoryEntry2;
        });
    }

    public List<@Nullable ElementHistoryEntry> getHistoryEntries(List<String> uniformPaths, boolean forceExistence) throws StorageException {
        return this.delegate.getValues(uniformPaths, forceExistence);
    }

    public List<@Nullable ElementHistoryEntry> getHistoryEntries(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public Map<String, ElementHistoryEntry> getHistoryEntriesByPaths(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValuesByKeys(uniformPaths);
    }

    public Map<UniformPath, ElementHistoryEntry> getHistoryEntriesByUniformPaths(Collection<UniformPath> uniformPaths) throws StorageException {
        return this.delegate.getValuesByKeys((Collection)UniformPathCompatibilityUtil.asUniformPathStrings(uniformPaths)).entrySet().stream().collect(Collectors.toMap(entry -> UniformPathCompatibilityUtil.convert((String)((String)entry.getKey())), Map.Entry::getValue));
    }

    public void setHistoryEntries(PairList<String, ElementHistoryEntry> elementHistoryEntries) throws StorageException {
        this.delegate.setValues(elementHistoryEntries);
    }

    public void setHistoryEntry(String uniformPath, ElementHistoryEntry elementHistoryEntry) throws StorageException {
        this.delegate.setValue(uniformPath, (Object)elementHistoryEntry);
    }

    public void setHistoryEntry(UniformPath uniformPath, ElementHistoryEntry elementHistoryEntry) throws StorageException {
        this.delegate.setValue(uniformPath.toStringAsMigrationFrontier(), (Object)elementHistoryEntry);
    }

    public PairList<String, ElementHistoryEntry> getEntriesByUniformPathPrefix(String uniformPathPrefix) throws StorageException {
        return this.delegate.getEntriesStartingWith(uniformPathPrefix);
    }

    public @Nullable ElementHistoryEntry getHistoryEntry(String uniformPath) throws StorageException {
        return (ElementHistoryEntry)((Object)this.delegate.getValue(uniformPath));
    }

    public void removeHistoryEntry(String uniformPath) throws StorageException {
        this.delegate.removeValue(uniformPath);
    }

    public PairList<String, ElementHistoryEntry> getAllHistoryEntries() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

