/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teamscale.index.repository.RepositoryContentUpdaterFilteringSupport;
import eu.cqse.check.framework.core.ShallowEntityUtils;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.preprocessor.PreprocessorFactory;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@ExportToTypeScript
@IndexValueClass
public class TokenElementInfo
extends BasicTokenElementInfo {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private List<IToken> tokens = null;
    @JsonIgnore
    private final List<IToken> preprocessedTokens;
    @JsonIgnore
    private final List<ShallowEntity> shallowEntities;
    @JsonIgnore
    private UnmodifiableList<ShallowEntity> shallowEntitiesWithoutPreprocessorTokens = null;
    @JsonIgnore
    private UnmodifiableList<ShallowEntity> shallowEntitiesWithRevertedPreprocessorTokens = null;
    @JsonIgnore
    private transient UnmodifiableList<IToken> rawTokens = null;
    @JsonIgnore
    private transient UnmodifiableList<ShallowEntity> rawShallowEntities = null;

    public TokenElementInfo(String uniformPath, ELanguage language, boolean isFileLanguageSetByUser, String rawText, List<Deletion> filterDeletions, Collection<TokenElementDetailBase> details, List<IToken> preprocessedTokens, List<ShallowEntity> shallowEntities) {
        super(uniformPath, language, isFileLanguageSetByUser, rawText, filterDeletions, details);
        this.preprocessedTokens = preprocessedTokens;
        this.shallowEntities = shallowEntities;
    }

    protected TokenElementInfo(TokenElementInfo other) {
        super((BasicTokenElementInfo)other);
        this.tokens = other.tokens;
        this.preprocessedTokens = other.preprocessedTokens;
        this.shallowEntities = other.shallowEntities;
        this.shallowEntitiesWithoutPreprocessorTokens = other.shallowEntitiesWithoutPreprocessorTokens;
        this.shallowEntitiesWithRevertedPreprocessorTokens = other.shallowEntitiesWithRevertedPreprocessorTokens;
        this.rawShallowEntities = other.rawShallowEntities;
    }

    public static TokenElementInfo createWithLocalPreprocessing(String uniformPath, ELanguage language, String content) {
        ArrayList<Deletion> filterDeletions = new ArrayList<Deletion>();
        RepositoryContentUpdaterFilteringSupport.filterLanguageSpecificMethods(uniformPath, content, filterDeletions, language);
        return TokenElementInfo.createWithLocalPreprocessing(uniformPath, language, false, content, filterDeletions, Collections.emptyList());
    }

    public static TokenElementInfo createWithLocalPreprocessing(UniformPath uniformPath, ELanguage language, String content) {
        return TokenElementInfo.createWithLocalPreprocessing(uniformPath.toString(), language, content);
    }

    public static TokenElementInfo createWithLocalPreprocessing(UniformPath uniformPath, ELanguage language, String content, List<Deletion> filterDeletions) {
        return TokenElementInfo.createWithLocalPreprocessing(uniformPath.toString(), language, false, content, filterDeletions, Collections.emptyList());
    }

    public static TokenElementInfo createWithLocalPreprocessing(String uniformPathAsString, ELanguage language, boolean isFileLanguageSetByUser, String text, List<Deletion> filterDeletions, Collection<TokenElementDetailBase> tokenElementDetails) {
        return TokenElementInfo.createWithPreprocessing(uniformPathAsString, language, isFileLanguageSetByUser, text, filterDeletions, tokenElementDetails, PreprocessorFactory.createLocalPreprocessor((ELanguage)language).orElse(null));
    }

    private static TokenElementInfo createWithPreprocessing(String uniformPathAsString, ELanguage language, boolean isFileLanguageSetByUser, String text, List<Deletion> filterDeletions, Collection<TokenElementDetailBase> tokenElementDetails, IPreprocessor preprocessor) {
        List shallowEntities;
        StringOffsetTransformer transformer = new StringOffsetTransformer(new ArrayList<Deletion>(filterDeletions));
        String filteredText = transformer.filterString(text);
        List tokens = ScannerUtils.getTokens((String)filteredText, (ELanguage)language, (String)uniformPathAsString);
        if (preprocessor != null) {
            tokens = preprocessor.preprocess(uniformPathAsString, tokens);
            PreprocessorUtils.clearIfTokenNumberLimitExceeded((List)tokens, (String)uniformPathAsString);
        }
        if (ShallowParserFactory.supportsLanguage((ELanguage)language)) {
            try {
                shallowEntities = ShallowParserFactory.createParser((ELanguage)language).parseTopLevel(tokens);
            }
            catch (ShallowParserException e) {
                throw new AssertionError((Object)"Can not happen as we checked for the language before!");
            }
        } else {
            shallowEntities = null;
        }
        return new TokenElementInfo(uniformPathAsString, language, isFileLanguageSetByUser, text, filterDeletions, tokenElementDetails, tokens, shallowEntities);
    }

    public @NonNull UnmodifiableList<IToken> getTokens() {
        if (this.tokens == null) {
            if (!PreprocessorUtils.hasPreprocessor((ELanguage)this.getLanguage())) {
                this.tokens = this.preprocessedTokens;
            } else if (this.tokens == null) {
                this.tokens = ScannerUtils.getTokens((String)this.getFilteredText(), (ELanguage)this.language, (String)this.uniformPath);
            }
        }
        return CollectionUtils.asUnmodifiable(this.tokens);
    }

    public int calculateNumberOfLines() {
        return StringUtils.countLines((String)this.text);
    }

    public UnmodifiableList<IToken> getRawTokens() {
        if (this.rawTokens != null) {
            return this.rawTokens;
        }
        this.rawTokens = CollectionUtils.asUnmodifiable((List)ScannerUtils.getTokens((String)this.getText(), (ELanguage)this.language, (String)this.getUniformPath()));
        return this.rawTokens;
    }

    public List<IToken> getPreprocessedTokens() {
        return CollectionUtils.asUnmodifiable(this.preprocessedTokens);
    }

    public UnmodifiableList<ShallowEntity> getShallowEntitiesWithoutPreprocessorTokens() {
        if (this.shallowEntities == null) {
            return null;
        }
        if (this.shallowEntitiesWithoutPreprocessorTokens != null) {
            return this.shallowEntitiesWithoutPreprocessorTokens;
        }
        this.shallowEntitiesWithoutPreprocessorTokens = PreprocessorUtils.hasPreprocessor((ELanguage)this.language) ? CollectionUtils.asUnmodifiable((List)ShallowEntityUtils.filterCPreprocessorTokens(this.shallowEntities)) : CollectionUtils.asUnmodifiable((List)ShallowEntityUtils.cloneShallowEntities(this.shallowEntities));
        return this.shallowEntitiesWithoutPreprocessorTokens;
    }

    public UnmodifiableList<ShallowEntity> getShallowEntitiesWithRevertedPreprocessorTokens() {
        if (this.shallowEntities == null) {
            return null;
        }
        if (this.shallowEntitiesWithRevertedPreprocessorTokens != null) {
            return this.shallowEntitiesWithRevertedPreprocessorTokens;
        }
        this.shallowEntitiesWithRevertedPreprocessorTokens = PreprocessorUtils.hasPreprocessor((ELanguage)this.language) ? CollectionUtils.asUnmodifiable((List)CPreprocessingUtils.revertCPreprocessorTokensToUnpreprocessed(this.shallowEntities, this.getRawTokens())) : CollectionUtils.asUnmodifiable((List)ShallowEntityUtils.cloneShallowEntities(this.shallowEntities));
        return this.shallowEntitiesWithRevertedPreprocessorTokens;
    }

    public @Nullable UnmodifiableList<ShallowEntity> getShallowEntitiesWithPreprocessorTokens() {
        if (this.shallowEntities == null) {
            return null;
        }
        return CollectionUtils.asUnmodifiable(this.shallowEntities);
    }

    public List<ShallowEntity> getRawShallowEntities() {
        if (!ShallowParserFactory.supportsLanguage((ELanguage)this.language)) {
            return null;
        }
        try {
            if (this.rawShallowEntities == null) {
                this.rawShallowEntities = CollectionUtils.asUnmodifiable((List)ShallowParserFactory.createParser((ELanguage)this.language).parseTopLevel(this.getRawTokens()));
            }
            return this.rawShallowEntities;
        }
        catch (ShallowParserException e) {
            throw new AssertionError("Impossible, as we checked for language " + String.valueOf(this.language) + " before!", e);
        }
    }

    public boolean isFilteredCompletely() {
        return this.filterDeletions.size() == 1 && this.text != null && ((Deletion)this.filterDeletions.get(0)).getStartOffset() == 0 && ((Deletion)this.filterDeletions.get(0)).getEndOffset() == this.text.length();
    }
}

