/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.search;

import com.teamscale.index.search.ESearchTokenSourceType;
import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import com.teamscale.index.utils.StringPoolDeserializer;
import com.teamscale.index.utils.StringPoolSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="code-search-base", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={SearchToken.class})
public class CodeSearchIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "code-search-base";
    private static final int MAX_TOKEN_LENGTH = 128;

    public CodeSearchIndex(IStore store) {
        super(store);
    }

    public void storeTokens(List<SearchToken> tokens) throws StorageException {
        Map sourceAbbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(CollectionUtils.mapToSet(tokens, SearchToken::getSourceName));
        ListMap groupedByKey = new ListMap();
        for (SearchToken token : tokens) {
            if (token.getText().length() > 128) continue;
            Object key = CodeSearchIndex.makeKey(token.getSourceType(), (Integer)sourceAbbreviationMap.get(token.getSourceName()));
            groupedByKey.add((Object)new ByteArrayWrapper((byte[])key), (Object)token);
        }
        PairList keysValues = new PairList();
        for (Object key : groupedByKey.getKeys()) {
            keysValues.add((Object)key.getBytes(), (Object)CodeSearchIndex.serializeTokens((List)groupedByKey.getCollection(key), null));
        }
        if (!keysValues.isEmpty()) {
            this.store.put(keysValues);
        }
    }

    public void removeSources(ESearchTokenSourceType sourceType, List<String> sourceNames) throws StorageException {
        Map sourceAbbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(new HashSet<String>(sourceNames));
        this.store.remove(CollectionUtils.map(sourceNames, name -> CodeSearchIndex.makeKey(sourceType, (Integer)sourceAbbreviationMap.get(name))));
    }

    private static byte[] makeKey(ESearchTokenSourceType sourceType, int abbreviatedSourceName) {
        byte[] key = new byte[5];
        key[0] = sourceType.getEncodingByte();
        ByteArrayUtils.storeIntInArray((int)abbreviatedSourceName, (byte[])key, (int)1);
        return key;
    }

    List<SearchSource> parseKeys(List<StorageKey> keys) throws StorageException {
        List raw = CollectionUtils.map(keys, StorageKey::getKey);
        List sourceNameParts = CollectionUtils.map((Collection)raw, array -> ByteArrayUtils.getIntFromByteArray((byte[])array, (int)1));
        Map sourceUnabbreviationMap = this.store.getAbbreviator().buildUnabbreviationMap(new HashSet(sourceNameParts));
        ArrayList<SearchSource> result = new ArrayList<SearchSource>(raw.size());
        for (int i = 0; i < raw.size(); ++i) {
            result.add(new SearchSource(ESearchTokenSourceType.fromEncodingByte(((byte[])raw.get(i))[0]), (String)sourceUnabbreviationMap.get(sourceNameParts.get(i))));
        }
        return result;
    }

    public List<SearchToken> getTokensBySource(Collection<SearchSource> sources) throws StorageException {
        return CodeSearchIndex.getTokensBySource(sources, (IStore)this.store, null, this.store.getAbbreviator());
    }

    static List<SearchToken> getTokensBySource(Collection<SearchSource> sources, IStore store, byte[] prefix, StorageStringAbbreviator abbreviator) throws StorageException {
        ArrayList<SearchSource> sourcesList = new ArrayList<SearchSource>(sources);
        Map sourceAbbreviationMap = abbreviator.buildAbbreviationMap(CollectionUtils.mapToSet(sources, SearchSource::getSourceName));
        List keys = CollectionUtils.map(sourcesList, source -> CodeSearchIndex.makeKey(source.getSourceType(), (Integer)sourceAbbreviationMap.get(source.getSourceName())));
        if (prefix != null) {
            keys = CollectionUtils.map((Collection)keys, key -> ByteArrayUtils.concat((byte[][])new byte[][]{prefix, key}));
        }
        List values = store.get(keys);
        ArrayList<SearchToken> result = new ArrayList<SearchToken>();
        for (int i = 0; i < sourcesList.size(); ++i) {
            result.addAll(CodeSearchIndex.deserializeTokens((byte[])values.get(i), (SearchSource)sourcesList.get(i), null));
        }
        return result;
    }

    List<byte[]> getRawData(List<byte[]> rawKeys) throws StorageException {
        return this.store.get(rawKeys);
    }

    static byte[] serializeTokens(final List<SearchToken> tokens, @Nullable StorageStringAbbreviator sourceStringAbbreviator) throws StorageException {
        tokens.sort(Comparator.comparingLong(SearchToken::getOffset).thenComparing(SearchToken::getText));
        final Map sourceAbbreviationMap = sourceStringAbbreviator == null ? null : sourceStringAbbreviator.buildAbbreviationMap(CollectionUtils.mapToSet(tokens, SearchToken::getSourceName));
        StringPoolSerializer serializer = new StringPoolSerializer(){

            @Override
            protected void serializeData(DataOutputStream dos) throws IOException {
                dos.writeInt(tokens.size());
                for (SearchToken token : tokens) {
                    this.writeToken(dos, token);
                }
            }

            private void writeToken(DataOutputStream dos, SearchToken token) throws IOException {
                this.writeString(token.getText(), dos);
                dos.writeInt(token.getOffset());
                dos.writeByte(token.getSignificance());
                if (sourceAbbreviationMap != null) {
                    dos.writeByte(token.getSourceType().getEncodingByte());
                    dos.writeInt((Integer)sourceAbbreviationMap.get(token.getSourceName()));
                }
            }
        };
        CodeSearchIndex.fillStringPool(tokens, serializer);
        return serializer.serialize();
    }

    private static void fillStringPool(List<SearchToken> tokens, StringPoolSerializer serializer) {
        for (SearchToken token : tokens) {
            serializer.addString(token.getText());
        }
    }

    static List<SearchToken> deserializeTokens(byte[] value, final @Nullable SearchSource source, final @Nullable StorageStringAbbreviator sourceStringAbbreviator) {
        if (value == null) {
            return new ArrayList<SearchToken>();
        }
        if (source == null && sourceStringAbbreviator == null) {
            throw new AssertionError((Object)"Either source or sourceStringAbbreviator must be non-null!");
        }
        final ArrayList<SearchToken> result = new ArrayList<SearchToken>();
        new StringPoolDeserializer(){

            @Override
            protected void deserializeData(DataInputStream din) throws IOException {
                int numberOfTokens = din.readInt();
                for (int i = 0; i < numberOfTokens; ++i) {
                    result.add(this.readSearchToken(din));
                }
            }

            private SearchToken readSearchToken(DataInputStream din) throws IOException {
                String sourceName;
                ESearchTokenSourceType sourceType;
                String text = this.readString(din);
                int offset = din.readInt();
                byte significance = din.readByte();
                if (source == null) {
                    sourceType = ESearchTokenSourceType.fromEncodingByte(din.readByte());
                    sourceName = this.unabbreviate(din.readInt());
                } else {
                    sourceType = source.getSourceType();
                    sourceName = source.getSourceName();
                }
                return new SearchToken(text, sourceType, sourceName, offset, significance);
            }

            private String unabbreviate(int encodedSorceName) throws IOException {
                try {
                    return sourceStringAbbreviator.unabbreviate(encodedSorceName);
                }
                catch (StorageException e) {
                    throw new IOException("Unabbreviation failed, which should actually never happen: " + e.getMessage(), e);
                }
            }
        }.deserialize(value);
        return result;
    }
}

