/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import java.util.HashSet;
import java.util.Map;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="simulink-plc-coder-traces", options={EStorageOption.BRANCHED})
public class SimulinkPlcCoderTraceIndex
implements IProjectIndex {
    private final ValueIndex<QualifiedNameLocation> delegate;

    public SimulinkPlcCoderTraceIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void overwriteWithNewSimulinkTraces(Map<String, QualifiedNameLocation> codeToSimulinkTraces) throws StorageException {
        if (codeToSimulinkTraces.isEmpty()) {
            this.delegate.removeAllEntries();
            return;
        }
        Map previousIndexEntries = this.delegate.getAllEntries().toMap();
        HashSet keysToDelete = new HashSet(previousIndexEntries.keySet());
        PairList entriesToAddOrChange = new PairList();
        for (Map.Entry<String, QualifiedNameLocation> newEntry : codeToSimulinkTraces.entrySet()) {
            String key = newEntry.getKey();
            QualifiedNameLocation oldEntry = (QualifiedNameLocation)previousIndexEntries.get(key);
            if (oldEntry == null) {
                entriesToAddOrChange.add((Object)key, (Object)newEntry.getValue());
                continue;
            }
            if (oldEntry.equals((Object)newEntry.getValue())) {
                keysToDelete.remove(key);
                continue;
            }
            entriesToAddOrChange.add((Object)key, (Object)newEntry.getValue());
        }
        this.delegate.removeValues(keysToDelete);
        this.delegate.setValues(entriesToAddOrChange);
    }

    public PairList<String, QualifiedNameLocation> getAllTraces() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

