/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class AssociatedMethodTestInfo
implements Comparable<AssociatedMethodTestInfo> {
    private final CommitDescriptor commit;
    private final String partition;
    private final MethodLocation location;

    public AssociatedMethodTestInfo(String partition, UniformPath uniformPath, int associatedRegionStart, int associatedRegionEnd, CommitDescriptor commit) {
        this.partition = partition;
        this.commit = commit;
        this.location = new MethodLocation(uniformPath, new OffsetBasedRegion(associatedRegionStart, associatedRegionEnd));
    }

    public AssociatedMethodTestInfo withAssociatedMethod(AssociatedMethodInfo associatedMethodInfo) {
        return new AssociatedMethodTestInfo(this.partition, associatedMethodInfo.getUniformPath(), associatedMethodInfo.getAssociatedRegion().getStart(), associatedMethodInfo.getAssociatedRegion().getEnd(), this.commit);
    }

    public AssociatedMethodTestInfo withAssociatedMethodAndCommit(AssociatedMethodInfo associatedMethodInfo, CommitDescriptor commit) {
        return new AssociatedMethodTestInfo(this.partition, associatedMethodInfo.getUniformPath(), associatedMethodInfo.getAssociatedRegion().getStart(), associatedMethodInfo.getAssociatedRegion().getEnd(), commit);
    }

    public long getTimestamp() {
        return this.commit.getTimestamp();
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public UniformPath getUniformPath() {
        return this.location.getUniformPath();
    }

    public String getPartition() {
        return this.partition;
    }

    public OffsetBasedRegion getAssociatedRegion() {
        return this.location.getRegion();
    }

    public MethodLocation getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(AssociatedMethodTestInfo o) {
        return this.commit.compareTo(o.getCommit());
    }

    public String toString() {
        return String.format("[partition: %s, path: %s, region: %s, commit: %s]", this.partition, this.getUniformPath(), this.getAssociatedRegion(), this.commit);
    }
}

