/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.xml.OfflineSaxHandlerBase;
import org.xml.sax.Attributes;

public class AbapTableDumpXmlHandler<E extends Enum<E>>
extends OfflineSaxHandlerBase {
    private final Class<E> enumClass;
    private final StringBuilder currentContent = new StringBuilder();
    private E currentElement = null;
    private final List<Map<E, String>> records = new ArrayList<Map<E, String>>();
    private Map<E, String> currentRecord = new HashMap<E, String>();
    private String recordTag;

    public AbapTableDumpXmlHandler(Class<E> enumClass, String recordTag) {
        this.enumClass = enumClass;
        this.recordTag = recordTag;
    }

    public List<Map<E, String>> getRecords() {
        return this.records;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.currentElement = EnumUtils.valueOfIgnoreCase(this.enumClass, (String)qName);
        this.currentContent.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.currentElement != null) {
            this.currentContent.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equalsIgnoreCase(this.recordTag)) {
            this.records.add(this.currentRecord);
            this.currentRecord = new HashMap<E, String>();
        } else if (this.currentElement != null) {
            this.currentRecord.put(this.currentElement, this.currentContent.toString());
            this.currentElement = null;
        }
    }
}

