/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public class CoverageSourceQueryParameters
extends CoverageSourceParameterBase {
    @JsonProperty(value="allPartitions")
    @QueryParam(value="all-partitions")
    @Parameter(description="If this is true, all available test coverage partitions are considered.")
    private boolean allPartitions;
    @JsonProperty(value="partitions")
    @QueryParam(value="partitions")
    @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider.")
    private List<String> partitions;
    @JsonProperty(value="crossAnnotationProjectPatterns")
    @QueryParam(value="cross-annotation-project-patterns")
    @Parameter(description="This parameter may be given multiple times. Specifies further Teamscale projects from which to consider test coverage.")
    private @NonNull List<String> crossAnnotationProjectPatterns;
    public static final CoverageSourceQueryParameters ALL_PARTITIONS = new CoverageSourceQueryParameters(List.of(), List.of(), true);
    public static final CoverageSourceQueryParameters NO_PARTITIONS = new CoverageSourceQueryParameters(List.of(), List.of(), false);

    @JsonCreator
    public CoverageSourceQueryParameters() {
    }

    public CoverageSourceQueryParameters(@NonNull List<String> crossAnnotationProjectPatterns, @NonNull List<String> partitions, boolean useAllPartitions) {
        this.crossAnnotationProjectPatterns = crossAnnotationProjectPatterns;
        this.partitions = partitions;
        this.allPartitions = useAllPartitions;
    }

    @Override
    public boolean useAllPartitions() {
        return this.allPartitions;
    }

    @Override
    public List<String> getPartitions() {
        return this.partitions;
    }

    @Override
    public List<String> getCrossAnnotationProjectPatterns() {
        return this.crossAnnotationProjectPatterns;
    }
}

