/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.trend;

import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;

class TgaTrendDataCache {
    private static final EnumSet<ETestGapState> UNCHANGED_AND_TESTED_STATES = EnumSet.of(ETestGapState.UNCHANGED, ETestGapState.TESTED_CHURN, ETestGapState.EXECUTED);
    private final TwoDimHashMap<UniformPath, OffsetBasedRegion, ETestGapState> cachedMethodStates = new TwoDimHashMap();
    private final CounterSet<ETestGapState> stateCounter = new CounterSet();

    TgaTrendDataCache() {
    }

    public void invalidateFiles(Collection<UniformPath> uniformPaths) {
        for (UniformPath uniformPath : uniformPaths) {
            Collection states = this.cachedMethodStates.getValuesByFirstKey((Object)uniformPath);
            if (states == null) continue;
            this.stateCounter.incAll(states, -1);
        }
        uniformPaths.forEach(arg_0 -> this.cachedMethodStates.remove(arg_0));
    }

    public void addData(AssessedTgaData data) {
        for (AssessedTgaData.AssessedMethodData method : data.getMethods()) {
            ETestGapState oldState = (ETestGapState)((Object)this.cachedMethodStates.getValue((Object)method.getLocation().getUniformPath(), (Object)method.getLocation().getRegion()));
            ETestGapState newState = method.getTestGapState();
            if (oldState != null) {
                this.stateCounter.inc((Object)oldState, -1);
            }
            this.stateCounter.inc((Object)newState);
            this.cachedMethodStates.putValue((Object)method.getLocation().getUniformPath(), (Object)method.getLocation().getRegion(), (Object)newState);
        }
    }

    public CounterSet<ETestGapState> countStates() {
        return this.stateCounter;
    }

    public Set<UniformPath> getKnownUniformPaths() {
        return this.cachedMethodStates.getFirstKeys();
    }

    public void methodsHaveBeenCovered(Collection<MethodLocation> newlyCoveredMethods, ETestGapState coveredState) {
        for (MethodLocation method : newlyCoveredMethods) {
            ETestGapState oldState = (ETestGapState)((Object)this.cachedMethodStates.getValue((Object)method.getUniformPath(), (Object)method.getRegion()));
            if (UNCHANGED_AND_TESTED_STATES.contains((Object)oldState)) continue;
            if (oldState != null) {
                this.stateCounter.inc((Object)oldState, -1);
            }
            this.cachedMethodStates.putValue((Object)method.getUniformPath(), (Object)method.getRegion(), (Object)coveredState);
            this.stateCounter.inc((Object)coveredState);
        }
    }
}

