/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.tests.PartitionAndTestExecutionResult;
import com.teamscale.index.tests.TestExecutionIndexDelta;
import com.teamscale.index.tests.TestExecutionWithPartition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="test-executions", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={TestExecutionWithPartition.class})
public class TestExecutionIndex
extends PartitionIndexBase
implements IProjectIndex,
IDeltaTranslatingIndex<TestExecutionIndexDelta> {
    public static final String INDEX_NAME = "test-executions";

    public TestExecutionIndex(IStore store) {
        super(store, false);
    }

    public TestExecutionWithPartition getTestExecution(String partition, UniformPath uniformPath) throws StorageException {
        String key = TestExecutionIndex.makeKey((String)partition, (String)uniformPath.toString());
        return this.deserialize(key, this.store.getWithString(key));
    }

    public Map<String, TestExecutionWithPartition> getAllTestExecutions() throws StorageException {
        PairList allEntries = this.store.getEntriesStartingWith(new byte[0]);
        HashMap<String, TestExecutionWithPartition> result = new HashMap<String, TestExecutionWithPartition>();
        for (Pair entry : allEntries) {
            String key = StringUtils.bytesToString((byte[])((byte[])entry.getFirst()));
            if (key.equals("#-#partition-list#-#")) continue;
            result.put(key, this.deserialize(key, (byte[])entry.getSecond()));
        }
        return result;
    }

    protected List<TestExecutionWithPartition> getValues(String partition, List<String> uniformPaths) throws StorageException {
        List keys = TestExecutionIndex.makeKeys((String)partition, uniformPaths);
        return this.getValues(keys);
    }

    private byte[] serialize(TestExecutionWithPartition testExecutionWithPartition) throws StorageException {
        return testExecutionWithPartition.serialize(this.store.getAbbreviator());
    }

    private TestExecutionWithPartition deserialize(String key, byte[] value) throws StorageException {
        PartitionAndPath partitionAndPath = TestExecutionIndex.splitKey((String)key);
        return TestExecutionWithPartition.deserialize(value, this.store.getAbbreviator(), partitionAndPath);
    }

    private TwoDimHashMap<String, String, TestExecutionWithPartition> getTestExecutionsForUniformPathsAndPartitions(Collection<String> partitions, Collection<String> tests) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (String partition : partitions) {
            for (String uniformPath : tests) {
                keys.add(TestExecutionIndex.makeKey((String)partition, (String)uniformPath));
            }
        }
        List<TestExecutionWithPartition> rawData = this.getValues(keys);
        TwoDimHashMap partitionsToPathAndValues = new TwoDimHashMap();
        int i = 0;
        for (String partition : partitions) {
            for (String uniformPath : tests) {
                TestExecutionWithPartition value = rawData.get(i);
                if (value != null) {
                    partitionsToPathAndValues.putValue((Object)partition, (Object)uniformPath, (Object)value);
                }
                ++i;
            }
        }
        return partitionsToPathAndValues;
    }

    public List<@Nullable TestExecutionWithPartition> getTestExecutionsForPartitionAndPaths(List<PartitionAndPath> testKeys) throws StorageException {
        return this.getValues(TestExecutionIndex.getRawKeys(testKeys));
    }

    private List<TestExecutionWithPartition> getValues(List<String> keys) throws StorageException {
        ArrayList<TestExecutionWithPartition> result = new ArrayList<TestExecutionWithPartition>();
        List values = this.store.getWithStrings(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            byte[] value = (byte[])values.get(i);
            result.add(this.deserialize(key, value));
        }
        return result;
    }

    public Map<UniformPath, TestExecutionWithPartition> getTestExecutionsByUniformPath(String partition) throws StorageException {
        HashMap<UniformPath, TestExecutionWithPartition> result = new HashMap<UniformPath, TestExecutionWithPartition>();
        for (Pair keyAndValue : this.store.getEntriesStartingWith(StringUtils.stringToBytes((String)TestExecutionIndex.makePartitionKeyPrefix((String)partition)))) {
            TestExecutionWithPartition testExecutionWithPartition = this.deserialize(StringUtils.bytesToString((byte[])((byte[])keyAndValue.getFirst())), (byte[])keyAndValue.getSecond());
            result.put(testExecutionWithPartition.getTestExecution().toUniformPath(), testExecutionWithPartition);
        }
        return result;
    }

    public SetMap<String, PartitionAndTestExecutionResult> getTestExecutionsFromAllPartitions(List<HashSet<String>> testUniformPaths) throws StorageException {
        TwoDimHashMap<String, String, TestExecutionWithPartition> testExecutions = this.getTestExecutionsForUniformPathsAndPartitions(this.getPartitions(), testUniformPaths.stream().filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        SetMap testResults = new SetMap();
        for (TestExecutionWithPartition execution : testExecutions.getValues()) {
            String path = execution.getTestExecution().getUniformPath();
            testResults.add((Object)path, (Object)new PartitionAndTestExecutionResult(execution.getPartition(), execution.getTestExecution().getUniformPath(), execution.getTestExecution().getResult()));
        }
        return testResults;
    }

    public void setTestExecutions(PairList<PartitionAndPath, TestExecutionWithPartition> uniformPathsAndValues) throws StorageException {
        Set partitions = uniformPathsAndValues.getSecondList().stream().map(TestExecutionWithPartition::getPartition).collect(Collectors.toSet());
        this.addPartitions(partitions);
        PairList keysValues = new PairList();
        for (int i = 0; i < uniformPathsAndValues.size(); ++i) {
            PartitionAndPath partitionAndPath = (PartitionAndPath)uniformPathsAndValues.getFirst(i);
            String key = TestExecutionIndex.makeKey((String)partitionAndPath.getPartition(), (String)partitionAndPath.getUniformPath());
            byte[] value = this.serialize((TestExecutionWithPartition)uniformPathsAndValues.getSecond(i));
            keysValues.add((Object)key, (Object)value);
        }
        this.store.putWithStrings(keysValues);
    }

    public void removeTestExecutions(String partition, List<String> uniformPaths) throws StorageException {
        this.store.removeWithStrings(TestExecutionIndex.makeKeys((String)partition, uniformPaths));
    }

    public void removeTestExecutions(Collection<PartitionAndPath> partitionAndPaths) throws StorageException {
        this.removeValues(partitionAndPaths);
    }

    public @NonNull TestExecutionIndexDelta resolveDelta(@NonNull KeyDelta storeDelta) {
        List addedOrChangedKeys = PartitionIndexBase.getPartitionAndPaths((Collection)storeDelta.getAddedOrChangedKeysAsStrings());
        List deletedKeys = PartitionIndexBase.getPartitionAndPaths((Collection)storeDelta.getDeletedKeysAsStrings());
        return new TestExecutionIndexDelta(addedOrChangedKeys, deletedKeys);
    }
}

