/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.boosttest;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.MacroBasedFrameworkTestCaseExtractionStrategyBase;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import com.teamscale.index.tests.extractor.boosttest.EBoostTestKeyword;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class BoostTestCaseExtractionStrategy
extends MacroBasedFrameworkTestCaseExtractionStrategyBase {
    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        PairList extractedTestCases = new PairList();
        List<IToken> testStartTokens = BoostTestCaseExtractionStrategy.findTestStartTokens(context, this.getTestCaseKeywords());
        PairList<IToken, Optional<ShallowEntity>> testEntities = this.findTestEntitiesCorrespondingToTestStartTokens(context, testStartTokens);
        Stack<String> testSuiteStack = new Stack<String>();
        for (int i = 0; i < testEntities.size(); ++i) {
            Optional optionalRawEntity = (Optional)testEntities.getSecond(i);
            if (optionalRawEntity.isEmpty()) continue;
            ShallowEntity rawEntity = (ShallowEntity)optionalRawEntity.get();
            IToken token = (IToken)testEntities.getFirst(i);
            String tokenText = token.getText();
            Optional<Pair<UniformPath, TestImplementation>> testImplementationPathPair = this.getTestImplementation(tokenText, rawEntity, context, testSuiteStack);
            testImplementationPathPair.ifPresent(testImplementationPath -> extractedTestCases.add((Object)((UniformPath)testImplementationPath.getFirst()).toString(), (Object)((TestImplementation)testImplementationPath.getSecond())));
        }
        return extractedTestCases;
    }

    private Optional<Pair<UniformPath, TestImplementation>> getTestImplementation(String tokenText, ShallowEntity rawEntity, TokenElementTransformContext context, Stack<String> testSuiteStack) {
        if (tokenText.equals(EBoostTestKeyword.BOOST_AUTO_TEST_SUITE.name()) || tokenText.equals(EBoostTestKeyword.BOOST_FIXTURE_TEST_SUITE.name())) {
            String testSuiteName = this.determineTestCaseOrTestSuiteName(context, (List<IToken>)rawEntity.includedTokens(), context.getPreprocessedTokens());
            if (!testSuiteName.isEmpty()) {
                testSuiteStack.push(testSuiteName);
            }
        } else if (tokenText.equals(EBoostTestKeyword.BOOST_AUTO_TEST_SUITE_END.name())) {
            testSuiteStack.pop();
        } else {
            String testCaseName = this.determineTestCaseOrTestSuiteName(context, (List<IToken>)rawEntity.includedTokens(), context.getPreprocessedTokens());
            if (testCaseName.isEmpty()) {
                return Optional.empty();
            }
            UniformPath testUniformPath = this.getTestUniformPath(testSuiteStack, testCaseName, context.getUniformPath());
            String testName = String.join((CharSequence)UniformPathUtils.SEPARATOR, testSuiteStack) + "/" + testCaseName;
            TestImplementation testImplementation = BoostTestCaseExtractionStrategy.determineTestImplementation(testName, context, rawEntity);
            return Optional.of(new Pair((Object)testUniformPath, (Object)testImplementation));
        }
        return Optional.empty();
    }

    private UniformPath getTestUniformPath(Stack<String> testSuiteTree, String testCaseName, String uniformPath) {
        testSuiteTree.push(testCaseName);
        UniformPath testUniformPath = TestCaseExtractionUtils.convertToTestImplementationUniformPath(uniformPath, testSuiteTree.toArray(new String[0]));
        testSuiteTree.pop();
        return testUniformPath;
    }

    private String determineTestCaseOrTestSuiteName(TokenElementTransformContext context, List<IToken> testCaseEntityTokens, List<IToken> preprocessedTokens) {
        int index = 2;
        if (testCaseEntityTokens.get(0).getText().equals(EBoostTestKeyword.BOOST_DATA_TEST_CASE_F.name())) {
            index = 4;
        }
        String testName = testCaseEntityTokens.get(index).getText();
        int nameTokenOffset = testCaseEntityTokens.get(index).getOffset();
        int preprocessedNameTokenIndex = TokenStreamUtils.indexOfByOffset(preprocessedTokens, (int)context.getNonRawOffset(nameTokenOffset));
        if (preprocessedNameTokenIndex != -1) {
            testName = preprocessedTokens.get(preprocessedNameTokenIndex).getText();
        }
        return testName;
    }

    @Override
    protected Set<String> getTestCaseKeywords() {
        return EBoostTestKeyword.VALUES;
    }

    @Override
    protected Optional<ShallowEntity> findEntity(TokenElementTransformContext context, int rawStartLine) {
        return context.getRawShallowEntityAtRawStartLine(rawStartLine, entity -> true);
    }
}

