/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.tracking.index.FindingSerializationUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class FindingChurnList
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    private final List<TrackedFinding> addedFindings;
    private final List<TrackedFinding> findingsInChangedCode;
    private final List<TrackedFinding> removedFindings;
    private final List<TrackedFinding> findingsAddedInBranch;
    private final List<TrackedFinding> findingsRemovedInBranch;

    public FindingChurnList(CommitDescriptor commit) {
        this(commit, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    FindingChurnList(CommitDescriptor commit, List<TrackedFinding> addedFindings, List<TrackedFinding> findingsInChangedCode, List<TrackedFinding> removedFindings) {
        this(commit, addedFindings, findingsInChangedCode, removedFindings, Collections.emptyList(), Collections.emptyList());
    }

    FindingChurnList(CommitDescriptor commit, List<TrackedFinding> addedFindings, List<TrackedFinding> findingsInChangedCode, List<TrackedFinding> removedFindings, List<TrackedFinding> findingsAddedInBranch, List<TrackedFinding> findingsRemovedInBranch) {
        super(commit);
        this.addedFindings = new ArrayList<TrackedFinding>(addedFindings);
        this.findingsAddedInBranch = new ArrayList<TrackedFinding>(findingsAddedInBranch);
        this.findingsInChangedCode = new ArrayList<TrackedFinding>(findingsInChangedCode);
        this.removedFindings = new ArrayList<TrackedFinding>(removedFindings);
        this.findingsRemovedInBranch = new ArrayList<TrackedFinding>(findingsRemovedInBranch);
    }

    public UnmodifiableList<TrackedFinding> getAddedFindings() {
        return CollectionUtils.asUnmodifiable(this.addedFindings);
    }

    private UnmodifiableSet<String> getAddedFindingIds() {
        return CollectionUtils.asUnmodifiable((Set)CollectionUtils.mapToSet(this.addedFindings, TrackedFinding::getId));
    }

    public UnmodifiableList<TrackedFinding> getFindingsAddedInBranch() {
        return CollectionUtils.asUnmodifiable(this.findingsAddedInBranch);
    }

    public UnmodifiableList<TrackedFinding> getFindingsInChangedCode() {
        return CollectionUtils.asUnmodifiable(this.findingsInChangedCode);
    }

    private UnmodifiableSet<String> getFindingInChangedCodeIds() {
        return CollectionUtils.asUnmodifiable((Set)CollectionUtils.mapToSet(this.findingsInChangedCode, TrackedFinding::getId));
    }

    public UnmodifiableList<TrackedFinding> getRemovedFindings() {
        return CollectionUtils.asUnmodifiable(this.removedFindings);
    }

    private UnmodifiableSet<String> getRemovedFindingIds() {
        return CollectionUtils.asUnmodifiable((Set)CollectionUtils.mapToSet(this.removedFindings, TrackedFinding::getId));
    }

    public UnmodifiableList<TrackedFinding> getFindingsRemovedInBranch() {
        return CollectionUtils.asUnmodifiable(this.findingsRemovedInBranch);
    }

    public void addAddedFindings(Collection<TrackedFinding> findings) {
        this.addedFindings.addAll(findings);
    }

    public void addFindingsInChangedCode(Collection<TrackedFinding> findings) {
        this.findingsInChangedCode.addAll(findings);
    }

    public void addRemovedFinding(TrackedFinding finding) {
        this.removedFindings.add(finding);
    }

    public void addRemovedFindings(Collection<TrackedFinding> findings) {
        this.removedFindings.addAll(findings);
    }

    public void addFindingsAddedInBranch(Collection<TrackedFinding> findings) {
        this.findingsAddedInBranch.addAll(findings);
    }

    public static FindingChurnList cloneWithRemovedFindings(FindingChurnList other, Set<String> findingIdsToRemove) {
        List<TrackedFinding> newAdded = FindingChurnList.copyAndRemoveFindings(other.addedFindings, findingIdsToRemove);
        List<TrackedFinding> newRemoved = FindingChurnList.copyAndRemoveFindings(other.removedFindings, findingIdsToRemove);
        List<TrackedFinding> newChangedCodeFindings = FindingChurnList.copyAndRemoveFindings(other.findingsInChangedCode, findingIdsToRemove);
        List<TrackedFinding> newAddedInBranch = FindingChurnList.copyAndRemoveFindings(other.findingsAddedInBranch, findingIdsToRemove);
        List<TrackedFinding> newRemovedInBranch = FindingChurnList.copyAndRemoveFindings(other.findingsRemovedInBranch, findingIdsToRemove);
        return new FindingChurnList(other.getCommit(), newAdded, newChangedCodeFindings, newRemoved, newAddedInBranch, newRemovedInBranch);
    }

    private static List<TrackedFinding> copyAndRemoveFindings(List<TrackedFinding> findings, Set<String> findingIdsToRemove) {
        ArrayList<TrackedFinding> newList = new ArrayList<TrackedFinding>(findings);
        newList.removeIf(finding -> findingIdsToRemove.contains(finding.getId()));
        return newList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        FindingChurnList.appendFindingsList(builder, this.addedFindings, "Added");
        FindingChurnList.appendFindingsList(builder, this.findingsInChangedCode, "Changed");
        FindingChurnList.appendFindingsList(builder, this.removedFindings, "Removed");
        FindingChurnList.appendFindingsList(builder, this.findingsAddedInBranch, "Added in branch");
        FindingChurnList.appendFindingsList(builder, this.findingsRemovedInBranch, "Removed in branch");
        return builder.toString();
    }

    private static void appendFindingsList(StringBuilder builder, Collection<TrackedFinding> findings, String name) {
        builder.append(name + " findings (" + findings.size() + "):" + StringUtils.LINE_SEPARATOR);
        for (TrackedFinding finding : findings) {
            builder.append("  " + String.valueOf(finding) + StringUtils.LINE_SEPARATOR);
        }
    }

    public void registerFindingsRemovedInBranch(PairList<TrackedFinding, TrackedFinding> findingsTrackedFromBranch) {
        if (findingsTrackedFromBranch.isEmpty()) {
            return;
        }
        this.findingsRemovedInBranch.addAll(findingsTrackedFromBranch.extractFirstList());
        HashSet idsToRemove = new HashSet(CollectionUtils.map((Collection)findingsTrackedFromBranch.getSecondList(), TrackedFinding::getId));
        int oldSize = this.removedFindings.size();
        this.removedFindings.removeIf(finding -> idsToRemove.contains(finding.getId()));
        CCSMAssert.isTrue((findingsTrackedFromBranch.size() == oldSize - this.removedFindings.size() ? 1 : 0) != 0, (String)"Tried to remove non-existent element!");
    }

    public Map<String, TrackedFinding> getAllFindings() {
        HashMap<String, TrackedFinding> allFindings = new HashMap<String, TrackedFinding>();
        this.getAddedFindings().forEach(finding -> allFindings.put(finding.getId(), (TrackedFinding)finding));
        this.getFindingsAddedInBranch().forEach(finding -> allFindings.put(finding.getId(), (TrackedFinding)finding));
        this.getFindingsRemovedInBranch().forEach(finding -> allFindings.put(finding.getId(), (TrackedFinding)finding));
        this.getFindingsInChangedCode().forEach(finding -> allFindings.put(finding.getId(), (TrackedFinding)finding));
        this.getRemovedFindings().forEach(finding -> allFindings.put(finding.getId(), (TrackedFinding)finding));
        return allFindings;
    }

    public static Optional<FindingChurnList> aggregate(Collection<FindingChurnList> findingChurnLists) {
        return findingChurnLists.stream().filter(Objects::nonNull).distinct().sorted().reduce(FindingChurnList::aggregate);
    }

    public FindingChurnList aggregate(FindingChurnList other) {
        CCSMAssert.isTrue((this.compareTo(other) < 0 ? 1 : 0) != 0, (String)"Sum of finding churn lists must be done in strictly ascending order defined by the compareTo function.");
        Map<String, TrackedFinding> trackedFindingsById = this.getAllFindings();
        trackedFindingsById.putAll(other.getAllFindings());
        UnmodifiableSet<String> a1 = this.getAddedFindingIds();
        UnmodifiableSet<String> c1 = this.getFindingInChangedCodeIds();
        UnmodifiableSet<String> r1 = this.getRemovedFindingIds();
        UnmodifiableSet<String> a2 = other.getAddedFindingIds();
        UnmodifiableSet<String> c2 = other.getFindingInChangedCodeIds();
        UnmodifiableSet<String> r2 = other.getRemovedFindingIds();
        HashSet a3 = CollectionUtils.unionSet((Collection)CollectionUtils.subtract(a1, r2), (Collection[])new Collection[]{a2});
        Set c3 = CollectionUtils.subtract((Collection)CollectionUtils.unionSet((Collection)CollectionUtils.subtract(c2, a1), (Collection[])new Collection[]{c1}), r2);
        HashSet r3 = CollectionUtils.unionSet((Collection)CollectionUtils.subtract(r1, a2), (Collection[])new Collection[]{CollectionUtils.subtract(r2, a1)});
        return new FindingChurnList(other.getCommit(), FindingChurnList.resolveTrackedFindings(a3, trackedFindingsById), FindingChurnList.resolveTrackedFindings(c3, trackedFindingsById), FindingChurnList.resolveTrackedFindings(r3, trackedFindingsById));
    }

    private static List<TrackedFinding> resolveTrackedFindings(Set<String> findingIds, Map<String, TrackedFinding> trackedFindingsById) {
        return findingIds.stream().map(trackedFindingsById::get).collect(Collectors.toList());
    }

    public void removeResolvedFindings() {
        this.addedFindings.removeIf(finding -> !finding.isAlive());
        this.findingsInChangedCode.removeIf(finding -> !finding.isAlive());
        this.findingsAddedInBranch.removeIf(finding -> !finding.isAlive());
        this.removedFindings.removeIf(finding -> !finding.isAlive());
        this.findingsRemovedInBranch.removeIf(finding -> !finding.isAlive());
    }

    private Object writeReplace() {
        return new Ser(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }

    private void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getCommit());
        FindingSerializationUtils.serializeFindingsList(this.addedFindings, out);
        FindingSerializationUtils.serializeFindingsList(this.findingsInChangedCode, out);
        FindingSerializationUtils.serializeFindingsList(this.removedFindings, out);
        FindingSerializationUtils.serializeFindingsList(this.findingsAddedInBranch, out);
        FindingSerializationUtils.serializeFindingsList(this.findingsRemovedInBranch, out);
    }

    private static FindingChurnList readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        CommitDescriptor commit = (CommitDescriptor)in.readObject();
        List<TrackedFinding> addedFindings = FindingSerializationUtils.deserializeFindingsList(in);
        List<TrackedFinding> findingsInChangedCode = FindingSerializationUtils.deserializeFindingsList(in);
        List<TrackedFinding> removedFindings = FindingSerializationUtils.deserializeFindingsList(in);
        List<TrackedFinding> findingsAddedInBranch = FindingSerializationUtils.deserializeFindingsList(in);
        List<TrackedFinding> findingsRemovedInBranch = FindingSerializationUtils.deserializeFindingsList(in);
        return new FindingChurnList(commit, addedFindings, findingsInChangedCode, removedFindings, findingsAddedInBranch, findingsRemovedInBranch);
    }

    private static final class Ser
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FindingChurnList delegate;

        public Ser(FindingChurnList delegate) {
            this.delegate = delegate;
        }

        public Ser() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.delegate.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.delegate = FindingChurnList.readExternal(in);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }
}

