/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.FindingDeltaUtils;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedFindingContextMatchingStrategyBase;
import com.teamscale.index.tracking.algorithm.TrackedFindingWithContext;
import com.teamscale.index.tracking.algorithm.TrackedUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.cache4j.BasicCache;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IParameterizedFactory;
import org.conqat.lib.commons.region.FuzzyRegion;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.string.StringUtils;

public class DiffBasedMatchingStrategy
extends TrackedFindingContextMatchingStrategyBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pair<String, Diff.Delta<TrackedUnit>> NO_DIFF = new Pair(null, null);
    private final ICache<Pair<String, Integer>, Pair<String, Diff.Delta<TrackedUnit>>, NeverThrownRuntimeException> diffCache = new BasicCache("diffCache", (IParameterizedFactory)new DeltaCalculator(), ECachingStrategy.UNLIMITED.getBackend(0));
    private final Map<Pair<String, Integer>, TrackedFindingWithContext> oldFindingByPathAndBranch = Collections.synchronizedMap(new HashMap());

    @Override
    public PairList<TrackedFindingWithContext, TrackedFindingWithContext> performMatching(UnmodifiableSet<TrackedFindingWithContext> oldFindingContext, UnmodifiableSet<TrackedFindingWithContext> newFindingsWithContext) {
        ListMap<String, Pair<FuzzyRegion, TrackedFindingWithContext>> oldFindingsByMessagePathKey = this.fillOldFindingsMap(oldFindingContext);
        PairList trackingResult = new PairList();
        for (TrackedFindingWithContext newFinding : newFindingsWithContext) {
            List oldFindings = (List)oldFindingsByMessagePathKey.getCollectionOrElse((Object)DiffBasedMatchingStrategy.determineMessageAndPathKey(newFinding), Collections.emptyList());
            int bestMatchIndex = -1;
            int bestScore = -1;
            for (int i = 0; i < oldFindings.size(); ++i) {
                int score;
                Pair potentialMatch = (Pair)oldFindings.get(i);
                FuzzyRegion oldFindingInNewContentRegion = (FuzzyRegion)potentialMatch.getFirst();
                if (!DiffBasedMatchingStrategy.findingIsInRegion(newFinding, oldFindingInNewContentRegion) || (score = DiffBasedMatchingStrategy.getSimilarityScore(((TrackedFindingWithContext)potentialMatch.getSecond()).getFinding(), newFinding.getFinding())) <= bestScore && (score != bestScore || ((TrackedFindingWithContext)potentialMatch.getSecond()).getBranchIndex() != 0)) continue;
                bestMatchIndex = i;
                bestScore = score;
            }
            if (bestMatchIndex < 0) continue;
            TrackedFindingWithContext oldFinding = (TrackedFindingWithContext)((Pair)oldFindings.get(bestMatchIndex)).getSecond();
            trackingResult.add((Object)oldFinding, (Object)newFinding);
            oldFindings.remove(bestMatchIndex);
            oldFindings.removeIf(finding -> ((TrackedFindingWithContext)finding.getSecond()).getFinding().getId().equals(oldFinding.getFinding().getId()));
        }
        return trackingResult;
    }

    private static int getSimilarityScore(TrackedFinding finding1, TrackedFinding finding2) {
        if (finding1.getMessage().equals(finding2.getMessage())) {
            return 2;
        }
        if (FindingDeltaUtils.getNormalizedFindingMessage((IndexFinding)finding1).equals(FindingDeltaUtils.getNormalizedFindingMessage((IndexFinding)finding2))) {
            return 1;
        }
        return 0;
    }

    private ListMap<String, Pair<FuzzyRegion, TrackedFindingWithContext>> fillOldFindingsMap(UnmodifiableSet<TrackedFindingWithContext> oldFindingContext) {
        ListMap oldFindingsMap = new ListMap();
        for (TrackedFindingWithContext oldFinding : new ArrayList<TrackedFindingWithContext>((Collection<TrackedFindingWithContext>)oldFindingContext)) {
            this.oldFindingByPathAndBranch.put((Pair<String, Integer>)new Pair((Object)oldFinding.getElement().getUniformPath(), (Object)oldFinding.getBranchIndex()), oldFinding);
            String key = DiffBasedMatchingStrategy.determineMessageAndPathKey(oldFinding);
            FuzzyRegion expectedNewRegion = this.determineNewStartAndEndRegions(oldFinding);
            if (expectedNewRegion == null) continue;
            oldFindingsMap.add((Object)key, (Object)new Pair((Object)expectedNewRegion, (Object)oldFinding));
        }
        return oldFindingsMap;
    }

    private static boolean findingIsInRegion(TrackedFindingWithContext newFinding, FuzzyRegion region) {
        Region startIndexRegion = region.getStartIndexRegion();
        Region endIndexRegion = region.getEndIndexRegion();
        int newFindingEndIndex = newFinding.getContentStartUnitIndex() + newFinding.getContentLength() - 1;
        return startIndexRegion.containsPosition(newFinding.getContentStartUnitIndex()) && endIndexRegion.containsPosition(newFindingEndIndex);
    }

    private static String determineMessageAndPathKey(TrackedFindingWithContext finding) {
        return finding.getNormalizedMessage() + ":" + finding.getUniformPath();
    }

    private @Nullable FuzzyRegion determineNewStartAndEndRegions(TrackedFindingWithContext oldFinding) {
        Pair newPathAndDiff = (Pair)this.diffCache.obtain((Object)new Pair((Object)oldFinding.getElement().getUniformPath(), (Object)oldFinding.getBranchIndex()));
        if (newPathAndDiff == null || NO_DIFF.equals((Object)newPathAndDiff)) {
            return null;
        }
        Diff.Delta diff = (Diff.Delta)newPathAndDiff.getSecond();
        int oldStartIndex = oldFinding.getContentStartUnitIndex();
        int oldEndIndex = oldStartIndex + oldFinding.getContentLength() - 1;
        return DiffBasedMatchingStrategy.determineNewStartAndEndRegions(diff, oldStartIndex, oldEndIndex);
    }

    static FuzzyRegion determineNewStartAndEndRegions(Diff.Delta<?> diff, int oldStartIndex, int oldEndIndex) {
        int minNewStartIndex = oldStartIndex;
        int maxNewStartIndex = oldStartIndex;
        int minNewEndIndex = oldEndIndex;
        int maxNewEndIndex = oldEndIndex;
        for (int i = 0; i < diff.getSize(); ++i) {
            int correctedPosition;
            int position = diff.getPosition(i);
            if (position < 0) {
                correctedPosition = -position - 1;
                if (correctedPosition < oldStartIndex) {
                    --minNewStartIndex;
                    --maxNewStartIndex;
                    --minNewEndIndex;
                    --maxNewEndIndex;
                    continue;
                }
                if (correctedPosition > oldEndIndex) continue;
                --minNewEndIndex;
                --maxNewEndIndex;
                continue;
            }
            correctedPosition = position - 1;
            if (correctedPosition < minNewStartIndex) {
                ++minNewStartIndex;
                ++maxNewStartIndex;
                ++minNewEndIndex;
                ++maxNewEndIndex;
                continue;
            }
            if (correctedPosition <= maxNewStartIndex) {
                ++maxNewStartIndex;
                ++maxNewEndIndex;
                if (correctedPosition > minNewEndIndex) continue;
                ++minNewEndIndex;
                continue;
            }
            if (correctedPosition <= minNewEndIndex) {
                ++minNewEndIndex;
                ++maxNewEndIndex;
                continue;
            }
            if (correctedPosition > maxNewEndIndex + 1) continue;
            ++maxNewEndIndex;
        }
        minNewEndIndex = Math.max(minNewEndIndex, minNewStartIndex);
        maxNewStartIndex = Math.min(maxNewStartIndex, maxNewEndIndex);
        if (minNewStartIndex > maxNewEndIndex || minNewEndIndex > maxNewEndIndex || minNewStartIndex > maxNewStartIndex) {
            return null;
        }
        return new FuzzyRegion(minNewStartIndex, maxNewStartIndex, minNewEndIndex, maxNewEndIndex);
    }

    private final class DeltaCalculator
    implements IParameterizedFactory<Pair<String, Diff.Delta<TrackedUnit>>, Pair<String, Integer>, NeverThrownRuntimeException> {
        private static final int INITIAL_MAX_DIFF_SIZE = 10000;
        private static final int MAX_DIFF_REDUCTION_FACTOR = 10;
        private static final int LOWEST_MAX_DIFF_SIZE = 100;
        private static final int MAX_DIFF_SIZE_HIT_LIMIT = 20;
        private int maxDiffSize = 10000;
        private final Set<String> maxDiffHitPaths = Collections.synchronizedSet(new HashSet());

        private DeltaCalculator() {
        }

        public Pair<String, Diff.Delta<TrackedUnit>> create(Pair<String, Integer> oldPathAndBranch) {
            Integer parentBranchIndex;
            TrackedFindingWithContext oldFinding = DiffBasedMatchingStrategy.this.oldFindingByPathAndBranch.get(oldPathAndBranch);
            TrackedElement newElement = oldFinding.getPeerElementForBranch(parentBranchIndex = (Integer)oldPathAndBranch.getSecond());
            if (newElement == null) {
                return null;
            }
            TrackedElement oldElement = oldFinding.getElement();
            Diff.Delta delta = Diff.computeDelta(oldElement.getUnits(), newElement.getUnits(), (int)this.maxDiffSize);
            if (delta.getSize() >= this.maxDiffSize) {
                this.handleMaxDiffSizeHit(newElement);
                return NO_DIFF;
            }
            return new Pair((Object)newElement.getUniformPath(), (Object)delta);
        }

        private void handleMaxDiffSizeHit(TrackedElement element) {
            if (this.maxDiffSize <= 100) {
                return;
            }
            this.maxDiffHitPaths.add(element.getUniformPath());
            if (this.maxDiffHitPaths.size() >= 20) {
                LOGGER.error("Maximal diff size of " + this.maxDiffSize + " hit too often during tracking. Reducing maximal diff size. Culprits (which might include generated code) are: " + StringUtils.concat(this.maxDiffHitPaths, (String)", "));
                this.maxDiffSize /= 10;
                this.maxDiffHitPaths.clear();
            }
        }
    }
}

