/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\f\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0002J\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u0014J&\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u001d2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001dH\u0014J&\u00103\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010)\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u001dH\u0002J\u0018\u00105\u001a\u0002062\u0006\u0010)\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u001dH\u0014J\u0018\u00108\u001a\u0002062\u0006\u0010)\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u001dH\u0014J.\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u001dH\u0002J&\u0010=\u001a\u00020&2\u0006\u0010:\u001a\u00020>2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010)\u001a\u00020\u001dH\u0002J\u001e\u0010?\u001a\u00020&2\f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010)\u001a\u00020\u001dH\u0002J\u001e\u0010A\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010)\u001a\u00020\u001dH\u0002J&\u0010B\u001a\u00020&2\u0006\u0010:\u001a\u00020C2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010)\u001a\u00020\u001dH\u0002J\f\u0010D\u001a\u00020\u001d*\u00020\u0014H\u0002R\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001e\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FastStackAnalyzer;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;)V", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "handlers", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "insnsArray", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getInsnsArray", "()[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getInterpreter", "()Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nInsns", "", "queue", "", "queued", "", "top", "analyze", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "checkAssertions", "", "computeExceptionEdges", "getFrame", "insn", "initControlFlowAnalysis", "current", "m", "mergeControlFlowEdge", "dest", "frame", "newFrame", "nLocals", "nStack", "processControlFlowEdge", "jump", "visitControlFlowEdge", "", "successor", "visitControlFlowExceptionEdge", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitNopInsn", "f", "visitOpInsn", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "indexOf", "backend"})
@SourceDebugExtension(value={"SMAP\nFastStackAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FastStackAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1855#2,2:241\n12474#3,2:243\n1#4:245\n*S KotlinDebug\n*F\n+ 1 FastStackAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FastStackAnalyzer\n*L\n117#1:241,2\n145#1:243,2\n*E\n"})
public class FastStackAnalyzer<V extends Value> {
    @NotNull
    private final String owner;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final Interpreter<V> interpreter;
    @NotNull
    private final AbstractInsnNode[] insnsArray;
    private final int nInsns;
    @NotNull
    private final Frame<V>[] frames;
    @NotNull
    private final List<TryCatchBlockNode>[] handlers;
    @NotNull
    private final boolean[] queued;
    @NotNull
    private final int[] queue;
    private int top;

    public FastStackAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull Interpreter<V> interpreter2) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(interpreter2, "interpreter");
        this.owner = owner;
        this.method = method;
        this.interpreter = interpreter2;
        AbstractInsnNode[] abstractInsnNodeArray = this.method.instructions.toArray();
        Intrinsics.checkNotNullExpressionValue(abstractInsnNodeArray, "toArray(...)");
        this.insnsArray = abstractInsnNodeArray;
        this.nInsns = this.insnsArray.length;
        this.frames = new Frame[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    protected final Interpreter<V> getInterpreter() {
        return this.interpreter;
    }

    @NotNull
    protected final AbstractInsnNode[] getInsnsArray() {
        return this.insnsArray;
    }

    @NotNull
    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    protected boolean visitControlFlowEdge(int insn, int successor) {
        return true;
    }

    protected boolean visitControlFlowExceptionEdge(int insn, int successor) {
        return true;
    }

    @NotNull
    public final Frame<V>[] analyze() {
        if (this.nInsns == 0) {
            return this.frames;
        }
        this.checkAssertions();
        this.computeExceptionEdges();
        Frame<V> current = this.newFrame(this.method.maxLocals, this.method.maxStack);
        Frame<V> handler2 = this.newFrame(this.method.maxLocals, this.method.maxStack);
        this.initControlFlowAnalysis(current, this.method, this.owner);
        while (this.top > 0) {
            this.top += -1;
            int insn = this.queue[this.top];
            Intrinsics.checkNotNull(this.frames[insn]);
            this.queued[insn] = false;
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            int insnOpcode = insnNode.getOpcode();
            int insnType = insnNode.getType();
            try {
                Frame<V> f;
                switch (insnType) {
                    case 8: 
                    case 14: 
                    case 15: {
                        this.visitNopInsn(f, insn);
                        break;
                    }
                    default: {
                        current.init(f);
                        if (insnOpcode != 177) {
                            current.execute(insnNode, this.interpreter);
                        }
                        if (insnType == 7) {
                            Intrinsics.checkNotNull(insnNode, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                            this.visitJumpInsnNode((JumpInsnNode)insnNode, current, insn, insnOpcode);
                            break;
                        }
                        if (insnType == 12) {
                            Intrinsics.checkNotNull(insnNode, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                            this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode, current, insn);
                            break;
                        }
                        if (insnType == 11) {
                            Intrinsics.checkNotNull(insnNode, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                            this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode, current, insn);
                            break;
                        }
                        if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                        this.visitOpInsn(current, insn);
                    }
                }
                List<TryCatchBlockNode> list2 = this.handlers[insn];
                if (list2 == null) continue;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String string2;
                    String string3;
                    TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                    boolean bl = false;
                    String string4 = string3 = tcb.type;
                    if (string4 == null) {
                        string2 = "java/lang/Throwable";
                    } else {
                        Intrinsics.checkNotNull(string4);
                        string2 = string3;
                    }
                    Type exnType = Type.getObjectType(string2);
                    LabelNode labelNode = tcb.handler;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "handler");
                    int jump = this.indexOf(labelNode);
                    LabelNode labelNode2 = tcb.handler;
                    Intrinsics.checkNotNullExpressionValue(labelNode2, "handler");
                    if (!this.visitControlFlowExceptionEdge(insn, this.indexOf(labelNode2))) continue;
                    handler2.init(f);
                    handler2.clearStack();
                    handler2.push(this.interpreter.newValue(exnType));
                    this.mergeControlFlowEdge(jump, handler2);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction #" + insn + ' ' + InlineCodegenUtilsKt.getInsnText(insnNode) + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction #" + insn + ' ' + InlineCodegenUtilsKt.getInsnText(insnNode) + ": " + e.getMessage(), e);
            }
        }
        return this.frames;
    }

    private final int indexOf(AbstractInsnNode $this$indexOf) {
        return this.method.instructions.indexOf($this$indexOf);
    }

    @Nullable
    public final Frame<V> getFrame(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        return this.frames[this.indexOf(insn)];
    }

    private final void checkAssertions() {
        boolean bl;
        block2: {
            AbstractInsnNode[] $this$any$iv = this.insnsArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode element$iv;
                AbstractInsnNode it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
        }
    }

    private final void visitOpInsn(Frame<V> current, int insn) {
        this.processControlFlowEdge(current, insn, insn + 1);
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode, Frame<V> current, int insn) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue(labelNode, "dflt");
        int jump = this.indexOf(labelNode);
        this.processControlFlowEdge(current, insn, jump);
        List<LabelNode> list2 = insnNode.labels;
        Intrinsics.checkNotNullExpressionValue(list2, "labels");
        for (LabelNode label : CollectionsKt.reversed((Iterable)list2)) {
            Intrinsics.checkNotNull(label);
            jump = this.indexOf(label);
            this.processControlFlowEdge(current, insn, jump);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode, Frame<V> current, int insn) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue(labelNode, "dflt");
        int jump = this.indexOf(labelNode);
        this.processControlFlowEdge(current, insn, jump);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNull(label);
            jump = this.indexOf(label);
            this.processControlFlowEdge(current, insn, jump);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, Frame<V> current, int insn, int insnOpcode) {
        if (insnOpcode != 167) {
            this.processControlFlowEdge(current, insn, insn + 1);
        }
        LabelNode labelNode = insnNode.label;
        Intrinsics.checkNotNullExpressionValue(labelNode, "label");
        int jump = this.indexOf(labelNode);
        this.processControlFlowEdge(current, insn, jump);
    }

    private final void visitNopInsn(Frame<V> f, int insn) {
        this.processControlFlowEdge(f, insn, insn + 1);
    }

    private final void processControlFlowEdge(Frame<V> current, int insn, int jump) {
        if (this.visitControlFlowEdge(insn, jump)) {
            this.mergeControlFlowEdge(jump, current);
        }
    }

    private final void initControlFlowAnalysis(Frame<V> current, MethodNode m, String owner) {
        current.setReturn(this.interpreter.newValue(Type.getReturnType(m.desc)));
        Type[] args2 = Type.getArgumentTypes(m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType(owner);
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        Intrinsics.checkNotNull(args2);
        for (Type arg : args2) {
            current.setLocal(local++, this.interpreter.newValue(arg));
            if (arg.getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        this.mergeControlFlowEdge(0, current);
    }

    private final void computeExceptionEdges() {
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue(labelNode, "start");
            int start = this.indexOf(labelNode);
            List insnHandlers = this.handlers[start];
            if (insnHandlers == null) {
                this.handlers[start] = insnHandlers = (List)new ArrayList();
            }
            Intrinsics.checkNotNull(tcb);
            insnHandlers.add(tcb);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeControlFlowEdge(int dest, Frame<V> frame) {
        Frame<V> destFrame = this.frames[dest];
        if (destFrame == null) {
            void $this$mergeControlFlowEdge_u24lambda_u242;
            Frame<V> frame2;
            Frame<V> frame3 = frame2 = this.newFrame(frame.getLocals(), frame.getMaxStackSize());
            int n = dest;
            Frame<V>[] frameArray = this.frames;
            boolean bl = false;
            $this$mergeControlFlowEdge_u24lambda_u242.init(frame);
            Unit unit = Unit.INSTANCE;
            frameArray[n] = frame2;
            if (!this.queued[dest]) {
                this.queued[dest] = true;
                int n2 = this.top;
                this.top = n2 + 1;
                this.queue[n2] = dest;
            }
        }
    }
}

