/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.projectRoots;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.util.lang.JavaVersion;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3),
    JDK_1_1(LanguageLevel.JDK_1_3),
    JDK_1_2(LanguageLevel.JDK_1_3),
    JDK_1_3(LanguageLevel.JDK_1_3),
    JDK_1_4(LanguageLevel.JDK_1_4),
    JDK_1_5(LanguageLevel.JDK_1_5),
    JDK_1_6(LanguageLevel.JDK_1_6),
    JDK_1_7(LanguageLevel.JDK_1_7),
    JDK_1_8(LanguageLevel.JDK_1_8),
    JDK_1_9(LanguageLevel.JDK_1_9),
    JDK_10(LanguageLevel.JDK_10),
    JDK_11(LanguageLevel.JDK_11),
    JDK_12(LanguageLevel.JDK_12),
    JDK_13(LanguageLevel.JDK_13),
    JDK_14(LanguageLevel.JDK_14),
    JDK_15(LanguageLevel.JDK_15),
    JDK_16(LanguageLevel.JDK_16),
    JDK_17(LanguageLevel.JDK_17),
    JDK_18(LanguageLevel.JDK_X);

    private final LanguageLevel myMaxLanguageLevel;

    private JavaSdkVersion(LanguageLevel maxLanguageLevel) {
        if (maxLanguageLevel == null) {
            JavaSdkVersion.$$$reportNull$$$0(0);
        }
        this.myMaxLanguageLevel = maxLanguageLevel;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        LanguageLevel languageLevel = this.myMaxLanguageLevel;
        if (languageLevel == null) {
            JavaSdkVersion.$$$reportNull$$$0(1);
        }
        return languageLevel;
    }

    @Nullable
    public static JavaSdkVersion fromVersionString(@NotNull String versionString) {
        JavaVersion version;
        if (versionString == null) {
            JavaSdkVersion.$$$reportNull$$$0(7);
        }
        return (version = JavaVersion.tryParse(versionString)) != null ? JavaSdkVersion.fromJavaVersion(version) : null;
    }

    @Nullable
    public static JavaSdkVersion fromJavaVersion(@NotNull JavaVersion version) {
        JavaSdkVersion[] values2;
        if (version == null) {
            JavaSdkVersion.$$$reportNull$$$0(8);
        }
        return version.feature < (values2 = JavaSdkVersion.values()).length ? values2[version.feature] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxLanguageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/projectRoots/JavaSdkVersion";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/projectRoots/JavaSdkVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxLanguageLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromLanguageLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromVersionString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromJavaVersion";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

