/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.fs.FindFileByNamesInScopeParams;
import org.sonarsource.sonarlint.core.clientapi.client.fs.FindFileByNamesInScopeResponse;
import org.sonarsource.sonarlint.core.clientapi.client.fs.FoundFileDto;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.connection.SonarCloudConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.SonarQubeConnectionConfiguration;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang.StringUtils;

@Named
@Singleton
public class BindingClueProvider {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String SONAR_SCANNER_CONFIG_FILENAME = "sonar-project.properties";
    private static final String AUTOSCAN_CONFIG_FILENAME = ".sonarcloud.properties";
    private final ConnectionConfigurationRepository connectionRepository;
    private final SonarLintClient client;

    public BindingClueProvider(ConnectionConfigurationRepository connectionRepository, SonarLintClient client) {
        this.connectionRepository = connectionRepository;
        this.client = client;
    }

    public List<BindingClueWithConnections> collectBindingCluesWithConnections(String configScopeId, Set<String> connectionIds, @Nullable String projectKey) throws InterruptedException {
        List<BindingClue> bindingClues = this.collectBindingClues(configScopeId);
        if (projectKey != null && connectionIds.size() == 1) {
            for (BindingClue bindingClue : bindingClues) {
                String sonarProjectKey = bindingClue.getSonarProjectKey();
                if (sonarProjectKey == null || !sonarProjectKey.equals(projectKey)) continue;
                return List.of(new BindingClueWithConnections(bindingClue, connectionIds));
            }
        }
        return this.matchConnections(bindingClues, connectionIds);
    }

    private List<BindingClueWithConnections> matchConnections(List<BindingClue> bindingClues, Set<String> eligibleConnectionIds) {
        LOG.debug("Match connections...");
        ArrayList<BindingClueWithConnections> cluesAndConnections = new ArrayList<BindingClueWithConnections>();
        for (BindingClue bindingClue : bindingClues) {
            Set<String> connectionsIds = this.matchConnections(bindingClue, eligibleConnectionIds);
            if (connectionsIds.isEmpty()) continue;
            cluesAndConnections.add(new BindingClueWithConnections(bindingClue, connectionsIds));
        }
        LOG.debug("{} {} having at least one matching connection", (Object)cluesAndConnections.size(), (Object)SonarLintLogger.singlePlural(cluesAndConnections.size(), "clue", "clues"));
        return cluesAndConnections;
    }

    private List<BindingClue> collectBindingClues(String checkedConfigScopeId) throws InterruptedException {
        FindFileByNamesInScopeResponse response;
        LOG.debug("Query client for binding clues...");
        try {
            response = this.client.findFileByNamesInScope(new FindFileByNamesInScopeParams(checkedConfigScopeId, List.of(SONAR_SCANNER_CONFIG_FILENAME, AUTOSCAN_CONFIG_FILENAME))).get(1L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            LOG.error("Unable to search scanner clues: " + e.getCause().getMessage(), e.getCause());
            return List.of();
        }
        catch (TimeoutException e) {
            LOG.error("Unable to search scanner clues in time", e);
            return List.of();
        }
        ArrayList<BindingClue> bindingClues = new ArrayList<BindingClue>();
        for (FoundFileDto foundFile : response.getFoundFiles()) {
            BindingClue bindingClue;
            ScannerProperties scannerProps = BindingClueProvider.extractScannerProperties(foundFile);
            if (scannerProps == null || (bindingClue = BindingClueProvider.computeBindingClue(foundFile.getFileName(), scannerProps)) == null) continue;
            bindingClues.add(bindingClue);
        }
        LOG.debug("Found {} binding {}", (Object)bindingClues.size(), (Object)SonarLintLogger.singlePlural(bindingClues.size(), "clue", "clues"));
        return bindingClues;
    }

    private Set<String> matchConnections(BindingClue bindingClue, Set<String> eligibleConnectionIds) {
        if (bindingClue instanceof SonarQubeBindingClue) {
            String serverUrl = ((SonarQubeBindingClue)bindingClue).serverUrl;
            return eligibleConnectionIds.stream().map(this.connectionRepository::getConnectionById).filter(SonarQubeConnectionConfiguration.class::isInstance).map(SonarQubeConnectionConfiguration.class::cast).filter(c -> c.isSameServerUrl(serverUrl)).map(AbstractConnectionConfiguration::getConnectionId).collect(Collectors.toSet());
        }
        if (bindingClue instanceof SonarCloudBindingClue) {
            String organization = ((SonarCloudBindingClue)bindingClue).organization;
            return eligibleConnectionIds.stream().map(this.connectionRepository::getConnectionById).filter(SonarCloudConnectionConfiguration.class::isInstance).map(SonarCloudConnectionConfiguration.class::cast).filter(c -> organization == null || Objects.equals(organization, c.getOrganization())).map(AbstractConnectionConfiguration::getConnectionId).collect(Collectors.toSet());
        }
        return eligibleConnectionIds;
    }

    @CheckForNull
    private static ScannerProperties extractScannerProperties(FoundFileDto matchedFile) {
        LOG.debug("Extracting scanner properties from {}", (Object)matchedFile.getFilePath());
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(matchedFile.getContent()));
        }
        catch (Exception e) {
            LOG.error("Unable to parse content of file '{}'", (Object)matchedFile.getFilePath(), (Object)e);
            return null;
        }
        return new ScannerProperties(BindingClueProvider.getAndTrim(properties, "sonar.projectKey"), BindingClueProvider.getAndTrim(properties, "sonar.organization"), BindingClueProvider.getAndTrim(properties, "sonar.host.url"));
    }

    @CheckForNull
    private static String getAndTrim(Properties properties, String key) {
        return StringUtils.trimToNull(properties.getProperty(key));
    }

    @CheckForNull
    private static BindingClue computeBindingClue(String filename, ScannerProperties scannerProps) {
        if (AUTOSCAN_CONFIG_FILENAME.equals(filename)) {
            return new SonarCloudBindingClue(scannerProps.projectKey, scannerProps.organization);
        }
        if (scannerProps.organization != null) {
            return new SonarCloudBindingClue(scannerProps.projectKey, scannerProps.organization);
        }
        if (scannerProps.serverUrl != null) {
            if (StringUtils.removeEnd(scannerProps.serverUrl, "/").equals(SonarCloudConnectionConfiguration.getSonarCloudUrl())) {
                return new SonarCloudBindingClue(scannerProps.projectKey, null);
            }
            return new SonarQubeBindingClue(scannerProps.projectKey, scannerProps.serverUrl);
        }
        if (scannerProps.projectKey != null) {
            return new UnknownBindingClue(scannerProps.projectKey);
        }
        return null;
    }

    public static class SonarCloudBindingClue
    implements BindingClue {
        private final String sonarProjectKey;
        private final String organization;

        SonarCloudBindingClue(@Nullable String sonarProjectKey, @Nullable String organization) {
            this.sonarProjectKey = sonarProjectKey;
            this.organization = organization;
        }

        @Override
        public String getSonarProjectKey() {
            return this.sonarProjectKey;
        }
    }

    public static class SonarQubeBindingClue
    implements BindingClue {
        private final String sonarProjectKey;
        private final String serverUrl;

        SonarQubeBindingClue(@Nullable String sonarProjectKey, String serverUrl) {
            this.sonarProjectKey = sonarProjectKey;
            this.serverUrl = serverUrl;
        }

        @Override
        public String getSonarProjectKey() {
            return this.sonarProjectKey;
        }
    }

    public static class UnknownBindingClue
    implements BindingClue {
        private final String sonarProjectKey;

        UnknownBindingClue(String sonarProjectKey) {
            this.sonarProjectKey = sonarProjectKey;
        }

        @Override
        public String getSonarProjectKey() {
            return this.sonarProjectKey;
        }
    }

    public static interface BindingClue {
        @CheckForNull
        public String getSonarProjectKey();
    }

    private static class ScannerProperties {
        private final String projectKey;
        private final String organization;
        private final String serverUrl;

        private ScannerProperties(@Nullable String projectKey, @Nullable String organization, @Nullable String serverUrl) {
            this.projectKey = projectKey;
            this.organization = organization;
            this.serverUrl = serverUrl;
        }
    }

    public static class BindingClueWithConnections {
        private final BindingClue bindingClue;
        private final Set<String> connectionIds;

        BindingClueWithConnections(BindingClue bindingClue, Set<String> connectionIds) {
            this.bindingClue = bindingClue;
            this.connectionIds = connectionIds;
        }

        public BindingClue getBindingClue() {
            return this.bindingClue;
        }

        public Set<String> getConnectionIds() {
            return this.connectionIds;
        }
    }
}

