/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationRemovedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationUpdatedEvent;
import org.sonarsource.sonarlint.core.serverapi.component.ServerProject;

@Named
@Singleton
public class SonarProjectsCache {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ServerApiProvider serverApiProvider;
    private final Cache<String, TextSearchIndex<ServerProject>> textSearchIndexCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final Cache<SonarProjectKey, Optional<ServerProject>> singleProjectsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public SonarProjectsCache(ServerApiProvider serverApiProvider) {
        this.serverApiProvider = serverApiProvider;
    }

    @Subscribe
    public void connectionRemoved(ConnectionConfigurationRemovedEvent e) {
        this.evictAll(e.getRemovedConnectionId());
    }

    @Subscribe
    public void connectionUpdated(ConnectionConfigurationUpdatedEvent e) {
        this.evictAll(e.getUpdatedConnectionId());
    }

    private void evictAll(String connectionId) {
        this.textSearchIndexCache.invalidate((Object)connectionId);
        this.singleProjectsCache.invalidateAll();
    }

    public Optional<ServerProject> getSonarProject(String connectionId, String sonarProjectKey) {
        try {
            return (Optional)this.singleProjectsCache.get((Object)new SonarProjectKey(connectionId, sonarProjectKey), () -> {
                LOG.debug("Query project '{}' on connection '{}'...", (Object)sonarProjectKey, (Object)connectionId);
                try {
                    return this.serverApiProvider.getServerApi(connectionId).flatMap(s -> s.component().getProject(sonarProjectKey));
                }
                catch (Exception e) {
                    LOG.error("Error while querying project '{}' from connection '{}'", sonarProjectKey, connectionId, e);
                    return Optional.empty();
                }
            });
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public TextSearchIndex<ServerProject> getTextSearchIndexCached(String connectionId, @Nullable String projectKey) {
        try {
            if (projectKey != null) {
                return this.getTextSearchIndex(connectionId, projectKey);
            }
            return (TextSearchIndex)this.textSearchIndexCache.get((Object)connectionId, () -> this.getTextSearchIndex(connectionId, null));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    private TextSearchIndex<ServerProject> getTextSearchIndex(String connectionId, @Nullable String projectKey) {
        List projects;
        LOG.debug("Load projects from connection '{}'...", (Object)connectionId);
        try {
            if (projectKey != null) {
                Optional optProject = this.serverApiProvider.getServerApi(connectionId).map(s -> s.component().getProject(projectKey)).orElseThrow(() -> new IllegalStateException("Project not found"));
                projects = optProject.map(List::of).orElseGet(List::of);
            } else {
                projects = this.serverApiProvider.getServerApi(connectionId).map(s -> s.component().getAllProjects(new ProgressMonitor(null))).orElse(List.of());
            }
        }
        catch (Exception e) {
            LOG.error("Error while querying projects from connection '{}'", (Object)connectionId, (Object)e);
            return new TextSearchIndex<ServerProject>();
        }
        if (projects.isEmpty()) {
            LOG.debug("No projects found for connection '{}'", (Object)connectionId);
            return new TextSearchIndex<ServerProject>();
        }
        LOG.debug("Creating index for {} {}", (Object)projects.size(), (Object)SonarLintLogger.singlePlural(projects.size(), "project", "projects"));
        TextSearchIndex<ServerProject> index = new TextSearchIndex<ServerProject>();
        projects.forEach(p -> index.index((ServerProject)p, p.getKey() + " " + p.getName()));
        return index;
    }

    private static class SonarProjectKey {
        private final String connectionId;
        private final String projectKey;

        private SonarProjectKey(String connectionId, String projectKey) {
            this.connectionId = connectionId;
            this.projectKey = projectKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SonarProjectKey that = (SonarProjectKey)o;
            return this.connectionId.equals(that.connectionId) && this.projectKey.equals(that.projectKey);
        }

        public int hashCode() {
            return Objects.hash(this.connectionId, this.projectKey);
        }
    }
}

