/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RuleKey {
    private static final char SEPARATOR = ':';
    private final String repository;
    private final String rule;

    public RuleKey(String repository, String rule) {
        this.repository = repository;
        this.rule = rule;
    }

    public String repository() {
        return this.repository;
    }

    public String rule() {
        return this.rule;
    }

    public static RuleKey parse(String s) {
        int separatorIndex = s.indexOf(58);
        if (separatorIndex < 0) {
            throw new IllegalArgumentException("Invalid rule key: " + s);
        }
        String key = s.substring(0, separatorIndex);
        String repo = s.substring(separatorIndex + 1);
        return new RuleKey(key, repo);
    }

    public String toString() {
        return this.repository + ":" + this.rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleKey ruleKey = (RuleKey)o;
        return Objects.equals(this.repository, ruleKey.repository) && Objects.equals(this.rule, ruleKey.rule);
    }

    public int hashCode() {
        return Objects.hash(this.repository, this.rule);
    }
}

