/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.repository.config;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class BindingConfiguration {
    private final String connectionId;
    private final String sonarProjectKey;
    private final boolean bindingSuggestionDisabled;

    public BindingConfiguration(@Nullable String connectionId, @Nullable String sonarProjectKey, boolean bindingSuggestionDisabled) {
        this.connectionId = connectionId;
        this.sonarProjectKey = sonarProjectKey;
        this.bindingSuggestionDisabled = bindingSuggestionDisabled;
    }

    @CheckForNull
    public String getConnectionId() {
        return this.connectionId;
    }

    @CheckForNull
    public String getSonarProjectKey() {
        return this.sonarProjectKey;
    }

    public boolean isBindingSuggestionDisabled() {
        return this.bindingSuggestionDisabled;
    }

    public boolean isBound() {
        return this.connectionId != null && this.sonarProjectKey != null;
    }

    public boolean isBoundTo(String connectionId, String projectKey) {
        return Objects.equals(connectionId, this.connectionId) && Objects.equals(projectKey, this.sonarProjectKey);
    }

    public boolean isBoundToConnection(String connectionId) {
        return Objects.equals(connectionId, this.connectionId) && this.sonarProjectKey != null;
    }

    public boolean isBoundToProject(String projectKey) {
        return this.connectionId != null && Objects.equals(projectKey, this.sonarProjectKey);
    }

    public <G> Optional<G> ifBound(BiFunction<String, String, G> calledIfBound) {
        if (this.isBound()) {
            return Optional.of(calledIfBound.apply(this.connectionId, this.sonarProjectKey));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindingConfiguration that = (BindingConfiguration)o;
        return this.bindingSuggestionDisabled == that.bindingSuggestionDisabled && Objects.equals(this.connectionId, that.connectionId) && Objects.equals(this.sonarProjectKey, that.sonarProjectKey);
    }

    public int hashCode() {
        return Objects.hash(this.connectionId, this.sonarProjectKey, this.bindingSuggestionDisabled);
    }
}

