/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rule.extractor;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDescriptionSection;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class LegacyHotspotRuleDescriptionSectionsGenerator {
    private LegacyHotspotRuleDescriptionSectionsGenerator() {
    }

    static List<SonarLintRuleDescriptionSection> extractDescriptionSectionsFromHtml(@Nullable String descriptionInHtml) {
        if (descriptionInHtml == null || descriptionInHtml.isEmpty()) {
            return List.of();
        }
        String[] split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("", descriptionInHtml);
        String remainingText = split[0];
        String ruleDescriptionSection = split[1];
        split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("<h2>Exceptions</h2>", remainingText);
        remainingText = split[0];
        String exceptions = split[1];
        split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("<h2>Ask Yourself Whether</h2>", remainingText);
        remainingText = split[0];
        String askSection = split[1];
        split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("<h2>Sensitive Code Example</h2>", remainingText);
        remainingText = split[0];
        String sensitiveSection = split[1];
        split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("<h2>Noncompliant Code Example</h2>", remainingText);
        remainingText = split[0];
        String noncompliantSection = split[1];
        split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("<h2>Recommended Secure Coding Practices</h2>", remainingText);
        remainingText = split[0];
        String recommendedSection = split[1];
        split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("<h2>Compliant Solution</h2>", remainingText);
        remainingText = split[0];
        String compliantSection = split[1];
        split = LegacyHotspotRuleDescriptionSectionsGenerator.extractSection("<h2>See</h2>", remainingText);
        remainingText = split[0];
        String seeSection = split[1];
        Optional<SonarLintRuleDescriptionSection> rootSection = LegacyHotspotRuleDescriptionSectionsGenerator.createSection("root_cause", ruleDescriptionSection, exceptions, remainingText);
        Optional<SonarLintRuleDescriptionSection> assessSection = LegacyHotspotRuleDescriptionSectionsGenerator.createSection("assess_the_problem", askSection, sensitiveSection, noncompliantSection);
        Optional<SonarLintRuleDescriptionSection> fixSection = LegacyHotspotRuleDescriptionSectionsGenerator.createSection("how_to_fix", recommendedSection, compliantSection, seeSection);
        return Stream.of(rootSection, assessSection, fixSection).filter(Predicate.not(Optional::isEmpty)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private static String[] extractSection(String beginning, String description) {
        String endSection = "<h2>";
        int beginningIndex = description.indexOf(beginning);
        if (beginningIndex != -1) {
            int endIndex = description.indexOf(endSection, beginningIndex + beginning.length());
            if (endIndex == -1) {
                endIndex = description.length();
            }
            return new String[]{description.substring(0, beginningIndex) + description.substring(endIndex), description.substring(beginningIndex, endIndex)};
        }
        return new String[]{description, ""};
    }

    private static Optional<SonarLintRuleDescriptionSection> createSection(String sectionKey, String ... contentPieces) {
        String content = StringUtils.trimToNull(String.join((CharSequence)"", contentPieces));
        if (content == null) {
            return Optional.empty();
        }
        return Optional.of(new SonarLintRuleDescriptionSection(sectionKey, content, LegacyHotspotRuleDescriptionSectionsGenerator.emptyContextForConvertedHotspotSection()));
    }

    private static Optional<SonarLintRuleDescriptionSection.Context> emptyContextForConvertedHotspotSection() {
        return Optional.empty();
    }
}

