/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rules;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.AbstractRuleDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.GetEffectiveRuleDetailsParams;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.GetEffectiveRuleDetailsResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.GetStandaloneRuleDescriptionParams;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.GetStandaloneRuleDescriptionResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.ListAllStandaloneRulesDefinitionsResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleDefinitionDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleParamDefinitionDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleParamType;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RulesService;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.StandaloneRuleConfigDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.UpdateStandaloneRulesConfigurationParams;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.RuleKey;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.rules.RulesRepository;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamDefinition;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamType;
import org.sonarsource.sonarlint.core.rules.RuleDetails;
import org.sonarsource.sonarlint.core.rules.RuleDetailsAdapter;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerActiveRule;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerRule;
import org.sonarsource.sonarlint.core.serverconnection.AnalyzerConfiguration;
import org.sonarsource.sonarlint.core.serverconnection.storage.StorageException;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.sync.SynchronizationServiceImpl;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

@Named
@Singleton
public class RulesServiceImpl
implements RulesService {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ServerApiProvider serverApiProvider;
    private final ConfigurationRepository configurationRepository;
    private final RulesRepository rulesRepository;
    private final StorageService storageService;
    private final SynchronizationServiceImpl synchronizationService;
    private static final String COULD_NOT_FIND_RULE = "Could not find rule '";
    private final Map<String, StandaloneRuleConfigDto> standaloneRuleConfig = new ConcurrentHashMap<String, StandaloneRuleConfigDto>();

    @Inject
    public RulesServiceImpl(ServerApiProvider serverApiProvider, ConfigurationRepository configurationRepository, RulesRepository rulesRepository, StorageService storageService, SynchronizationServiceImpl synchronizationService, InitializeParams params) {
        this(serverApiProvider, configurationRepository, rulesRepository, storageService, synchronizationService, params.getStandaloneRuleConfigByKey());
    }

    RulesServiceImpl(ServerApiProvider serverApiProvider, ConfigurationRepository configurationRepository, RulesRepository rulesRepository, StorageService storageService, SynchronizationServiceImpl synchronizationService, Map<String, StandaloneRuleConfigDto> standaloneRuleConfigByKey) {
        this.serverApiProvider = serverApiProvider;
        this.configurationRepository = configurationRepository;
        this.rulesRepository = rulesRepository;
        this.storageService = storageService;
        this.synchronizationService = synchronizationService;
        this.standaloneRuleConfig.putAll(standaloneRuleConfigByKey);
    }

    @Override
    public CompletableFuture<GetEffectiveRuleDetailsResponse> getEffectiveRuleDetails(GetEffectiveRuleDetailsParams params) {
        String ruleKey = params.getRuleKey();
        Optional<Binding> effectiveBinding = this.configurationRepository.getEffectiveBinding(params.getConfigurationScopeId());
        if (effectiveBinding.isEmpty()) {
            Optional<SonarLintRuleDefinition> embeddedRule = this.rulesRepository.getEmbeddedRule(ruleKey);
            if (embeddedRule.isEmpty()) {
                return CompletableFuture.failedFuture(new IllegalArgumentException(COULD_NOT_FIND_RULE + ruleKey + "' in embedded rules"));
            }
            RuleDetails ruleDetails2 = RuleDetails.from(embeddedRule.get(), this.standaloneRuleConfig.get(ruleKey));
            return CompletableFuture.completedFuture(RulesServiceImpl.buildResponse(ruleDetails2, params.getContextKey()));
        }
        return this.getActiveRuleForBinding(ruleKey, effectiveBinding.get()).thenApply(ruleDetails -> RulesServiceImpl.buildResponse(ruleDetails, params.getContextKey()));
    }

    private CompletableFuture<RuleDetails> getActiveRuleForBinding(String ruleKey, Binding binding) {
        String connectionId = binding.getConnectionId();
        Optional<ServerApi> serverApi = this.serverApiProvider.getServerApi(connectionId);
        if (serverApi.isEmpty()) {
            return RulesServiceImpl.failedFutureUnknownConnection(connectionId);
        }
        boolean skipCleanCodeTaxonomy = this.synchronizationService.getServerConnection(connectionId, serverApi.get()).shouldSkipCleanCodeTaxonomy();
        return this.findServerActiveRuleInStorage(binding, ruleKey).map(storageRule -> this.hydrateDetailsWithServer(connectionId, (ServerActiveRule)storageRule, skipCleanCodeTaxonomy)).orElseGet(() -> this.rulesRepository.getRule(connectionId, ruleKey).map(r -> RuleDetails.from(r, this.standaloneRuleConfig.get(ruleKey))).map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.failedFuture(new IllegalArgumentException(COULD_NOT_FIND_RULE + ruleKey + "' in plugins loaded from '" + connectionId + "'"))));
    }

    private Optional<ServerActiveRule> findServerActiveRuleInStorage(Binding binding, String ruleKey) {
        AnalyzerConfiguration analyzerConfiguration;
        try {
            analyzerConfiguration = this.storageService.binding(binding).analyzerConfiguration().read();
        }
        catch (StorageException e) {
            return Optional.empty();
        }
        return analyzerConfiguration.getRuleSetByLanguageKey().values().stream().flatMap(s -> s.getRules().stream()).filter(r -> this.tryConvertDeprecatedKeys((ServerActiveRule)r, binding.getConnectionId()).getRuleKey().equals(ruleKey)).findFirst();
    }

    private CompletableFuture<RuleDetails> hydrateDetailsWithServer(String connectionId, ServerActiveRule activeRuleFromStorage, boolean skipCleanCodeTaxonomy) {
        String ruleKey = activeRuleFromStorage.getRuleKey();
        String templateKey = activeRuleFromStorage.getTemplateKey();
        if (StringUtils.isNotBlank(templateKey)) {
            return this.rulesRepository.getRule(connectionId, templateKey).map(templateRule -> this.serverApiProvider.getServerApi(connectionId).map(serverApi -> RulesServiceImpl.fetchRuleFromServer(connectionId, ruleKey, serverApi).thenApply(serverRule -> RuleDetails.merging(activeRuleFromStorage, serverRule, templateRule, skipCleanCodeTaxonomy))).orElseGet(() -> RulesServiceImpl.failedFutureUnknownConnection(connectionId))).orElseGet(() -> CompletableFuture.failedFuture(new IllegalStateException("Unable to find rule definition for rule template " + templateKey)));
        }
        return this.serverApiProvider.getServerApi(connectionId).map(serverApi -> RulesServiceImpl.fetchRuleFromServer(connectionId, ruleKey, serverApi).thenApply(serverRule -> this.rulesRepository.getRule(connectionId, ruleKey).map(ruleDefFromPlugin -> RuleDetails.merging(serverRule, ruleDefFromPlugin, skipCleanCodeTaxonomy)).orElseGet(() -> RuleDetails.merging(activeRuleFromStorage, serverRule)))).orElseGet(() -> RulesServiceImpl.failedFutureUnknownConnection(connectionId));
    }

    @NotNull
    private static CompletableFuture<RuleDetails> failedFutureUnknownConnection(String connectionId) {
        return CompletableFuture.failedFuture(new IllegalStateException("Unknown connection '" + connectionId + "'"));
    }

    private static CompletableFuture<ServerRule> fetchRuleFromServer(String connectionId, String ruleKey, ServerApi serverApi) {
        return serverApi.rules().getRule(ruleKey).handle((r, e) -> {
            if (e != null) {
                throw new IllegalStateException(COULD_NOT_FIND_RULE + ruleKey + "' on '" + connectionId + "'", (Throwable)e);
            }
            return r;
        });
    }

    private ServerActiveRule tryConvertDeprecatedKeys(ServerActiveRule possiblyDeprecatedActiveRuleFromStorage, String connectionId) {
        if (StringUtils.isNotBlank(possiblyDeprecatedActiveRuleFromStorage.getTemplateKey())) {
            Optional<SonarLintRuleDefinition> ruleOrTemplateDefinition = this.rulesRepository.getRule(connectionId, possiblyDeprecatedActiveRuleFromStorage.getTemplateKey());
            if (ruleOrTemplateDefinition.isEmpty()) {
                return possiblyDeprecatedActiveRuleFromStorage;
            }
            RuleKey ruleKeyPossiblyWithDeprecatedRepo = RuleKey.parse(possiblyDeprecatedActiveRuleFromStorage.getRuleKey());
            RuleKey templateRuleKeyWithCorrectRepo = RuleKey.parse(ruleOrTemplateDefinition.get().getKey());
            String ruleKey = new RuleKey(templateRuleKeyWithCorrectRepo.repository(), ruleKeyPossiblyWithDeprecatedRepo.rule()).toString();
            return new ServerActiveRule(ruleKey, possiblyDeprecatedActiveRuleFromStorage.getSeverity(), possiblyDeprecatedActiveRuleFromStorage.getParams(), ruleOrTemplateDefinition.get().getKey());
        }
        Optional<SonarLintRuleDefinition> ruleOrTemplateDefinition = this.rulesRepository.getRule(connectionId, possiblyDeprecatedActiveRuleFromStorage.getRuleKey());
        if (ruleOrTemplateDefinition.isEmpty()) {
            return possiblyDeprecatedActiveRuleFromStorage;
        }
        return new ServerActiveRule(ruleOrTemplateDefinition.get().getKey(), possiblyDeprecatedActiveRuleFromStorage.getSeverity(), possiblyDeprecatedActiveRuleFromStorage.getParams(), null);
    }

    private static GetEffectiveRuleDetailsResponse buildResponse(RuleDetails ruleDetails, @Nullable String contextKey) {
        return new GetEffectiveRuleDetailsResponse(RuleDetailsAdapter.transform(ruleDetails, contextKey));
    }

    @Override
    public CompletableFuture<ListAllStandaloneRulesDefinitionsResponse> listAllStandaloneRulesDefinitions() {
        return CompletableFuture.supplyAsync(() -> new ListAllStandaloneRulesDefinitionsResponse(this.rulesRepository.getEmbeddedRules().stream().map(RulesServiceImpl::convert).collect(Collectors.toMap(AbstractRuleDto::getKey, r -> r))));
    }

    @NotNull
    private static RuleDefinitionDto convert(SonarLintRuleDefinition r) {
        return new RuleDefinitionDto(r.getKey(), r.getName(), r.getDefaultSeverity(), r.getType(), r.getCleanCodeAttribute().orElse(null), r.getDefaultImpacts(), RulesServiceImpl.convert(r.getParams()), r.isActiveByDefault(), r.getLanguage());
    }

    private static Map<String, RuleParamDefinitionDto> convert(Map<String, SonarLintRuleParamDefinition> params) {
        return params.values().stream().map(RulesServiceImpl::convert).collect(Collectors.toMap(RuleParamDefinitionDto::getKey, r -> r));
    }

    private static RuleParamDefinitionDto convert(SonarLintRuleParamDefinition paramDef) {
        return new RuleParamDefinitionDto(paramDef.key(), paramDef.name(), paramDef.description(), paramDef.defaultValue(), RulesServiceImpl.convert(paramDef.type()), paramDef.multiple(), paramDef.possibleValues());
    }

    private static RuleParamType convert(SonarLintRuleParamType type) {
        try {
            return RuleParamType.valueOf(type.name());
        }
        catch (IllegalArgumentException unknownType) {
            LOG.warn("Unknown parameter type: " + type.name());
            return RuleParamType.STRING;
        }
    }

    @Override
    public CompletableFuture<GetStandaloneRuleDescriptionResponse> getStandaloneRuleDetails(GetStandaloneRuleDescriptionParams params) {
        String ruleKey = params.getRuleKey();
        Optional<SonarLintRuleDefinition> embeddedRule = this.rulesRepository.getEmbeddedRule(ruleKey);
        if (embeddedRule.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException(COULD_NOT_FIND_RULE + ruleKey + "' in embedded rules"));
        }
        SonarLintRuleDefinition ruleDefinition = embeddedRule.get();
        RuleDetails ruleDetails = RuleDetails.from(ruleDefinition, this.standaloneRuleConfig.get(ruleKey));
        return CompletableFuture.completedFuture(new GetStandaloneRuleDescriptionResponse(RulesServiceImpl.convert(ruleDefinition), RuleDetailsAdapter.transformDescriptions(ruleDetails, null)));
    }

    @Override
    public void updateStandaloneRulesConfiguration(UpdateStandaloneRulesConfigurationParams params) {
        this.setStandaloneRuleConfig(params.getRuleConfigByKey());
    }

    private synchronized void setStandaloneRuleConfig(Map<String, StandaloneRuleConfigDto> standaloneRuleConfig) {
        this.standaloneRuleConfig.clear();
        this.standaloneRuleConfig.putAll(standaloneRuleConfig);
    }
}

